/********************************************************************//**
 * \file iap2_parameters.h
 * \brief iAP2 Control session parameters
 *
 * \version $ $
 *
 * This header file declares structures associated with 
 * iAP2 control session message Parameters.
 *
 * \component global definition file
 *
 * \author Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
 *
 * \copyright (c) 2010 - 2016 ADIT Corporation
 *
 * \warning CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
 *          DO NOT CHANGE THE CODE MANUALLY
 ***********************************************************************/

#ifndef IAP2_PARAMETERS_H
#define IAP2_PARAMETERS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "iap2_subparameters.h"
#include <malloc.h>
#include <string.h>
#include <stdlib.h>

/**
 * Message: AccessoryAuthenticationSerialNumber
 */
#define IAP2_MSG_ID_ACCESSORY_AUTHENTICATION_SERIAL_NUMBER            0xAA06
/**
 * Message: AuthenticationCertificate
 */
#define IAP2_MSG_ID_AUTHENTICATION_CERTIFICATE                        0xAA01
/**
 * Message: AuthenticationResponse
 */
#define IAP2_MSG_ID_AUTHENTICATION_RESPONSE                           0xAA03
/**
 * Message: AuthenticationFailed
 */
#define IAP2_MSG_ID_AUTHENTICATION_FAILED                             0xAA04
/**
 * Message: AuthenticationSucceeded
 */
#define IAP2_MSG_ID_AUTHENTICATION_SUCCEEDED                          0xAA05
/**
 * Message: RequestAuthenticationCertificate
 */
#define IAP2_MSG_ID_REQUEST_AUTHENTICATION_CERTIFICATE                0xAA00
/**
 * Message: RequestAuthenticationChallengeResponse
 */
#define IAP2_MSG_ID_REQUEST_AUTHENTICATION_CHALLENGE_RESPONSE         0xAA02
/**
 * Message: IdentificationInformation
 */
#define IAP2_MSG_ID_IDENTIFICATION_INFORMATION                        0x1D01
/**
 * Message: CancelIdentification
 */
#define IAP2_MSG_ID_CANCEL_IDENTIFICATION                             0x1D05
/**
 * Message: IdentificationInformationUpdate
 */
#define IAP2_MSG_ID_IDENTIFICATION_INFORMATION_UPDATE                 0x1D06
/**
 * Message: StartIdentification
 */
#define IAP2_MSG_ID_START_IDENTIFICATION                              0x1D00
/**
 * Message: IdentificationAccepted
 */
#define IAP2_MSG_ID_IDENTIFICATION_ACCEPTED                           0x1D02
/**
 * Message: IdentificationRejected
 */
#define IAP2_MSG_ID_IDENTIFICATION_REJECTED                           0x1D03
/**
 * Message: RequestAppLaunch
 */
#define IAP2_MSG_ID_REQUEST_APP_LAUNCH                                0xEA02
/**
 * Message: OOBBTPairingAccessoryInformation
 */
#define IAP2_MSG_ID_OOBBT_PAIRING_ACCESSORY_INFORMATION               0x00B1
/**
 * Message: OOBBTPairingCompletionInformation
 */
#define IAP2_MSG_ID_OOBBT_PAIRING_COMPLETION_INFORMATION              0x00B3
/**
 * Message: OOBBTPairingLinkKeyInformation
 */
#define IAP2_MSG_ID_OOBBT_PAIRING_LINK_KEY_INFORMATION                0x00B2
/**
 * Message: StartOOBBTPairing
 */
#define IAP2_MSG_ID_START_OOBBT_PAIRING                               0x00B0
/**
 * Message: StopOOBBTPairing
 */
#define IAP2_MSG_ID_STOP_OOBBT_PAIRING                                0x00B4
/**
 * Message: RouteGuidanceManeuverUpdate
 */
#define IAP2_MSG_ID_ROUTE_GUIDANCE_MANEUVER_UPDATE                    0x5202
/**
 * Message: RouteGuidanceUpdate
 */
#define IAP2_MSG_ID_ROUTE_GUIDANCE_UPDATE                             0x5201
/**
 * Message: StartRouteGuidanceUpdate
 */
#define IAP2_MSG_ID_START_ROUTE_GUIDANCE_UPDATE                       0x5200
/**
 * Message: StopRouteGuidanceUpdate
 */
#define IAP2_MSG_ID_STOP_ROUTE_GUIDANCE_UPDATE                        0x5203
/**
 * Message: StartAssistiveTouch
 */
#define IAP2_MSG_ID_START_ASSISTIVE_TOUCH                             0x5400
/**
 * Message: StopAssistiveTouch
 */
#define IAP2_MSG_ID_STOP_ASSISTIVE_TOUCH                              0x5401
/**
 * Message: StartAssistiveTouchInformation
 */
#define IAP2_MSG_ID_START_ASSISTIVE_TOUCH_INFORMATION                 0x5402
/**
 * Message: StopAssistiveTouchInformation
 */
#define IAP2_MSG_ID_STOP_ASSISTIVE_TOUCH_INFORMATION                  0x5404
/**
 * Message: AssistiveTouchInformation
 */
#define IAP2_MSG_ID_ASSISTIVE_TOUCH_INFORMATION                       0x5403
/**
 * Message: BluetoothComponentInformation
 */
#define IAP2_MSG_ID_BLUETOOTH_COMPONENT_INFORMATION                   0x4E01
/**
 * Message: StartBluetoothConnectionUpdates
 */
#define IAP2_MSG_ID_START_BLUETOOTH_CONNECTION_UPDATES                0x4E03
/**
 * Message: StopBluetoothConnectionUpdates
 */
#define IAP2_MSG_ID_STOP_BLUETOOTH_CONNECTION_UPDATES                 0x4E05
/**
 * Message: BluetoothConnectionUpdate
 */
#define IAP2_MSG_ID_BLUETOOTH_CONNECTION_UPDATE                       0x4E04
/**
 * Message: AcceptCall
 */
#define IAP2_MSG_ID_ACCEPT_CALL                                       0x415B
/**
 * Message: EndCall
 */
#define IAP2_MSG_ID_END_CALL                                          0x415C
/**
 * Message: HoldStatusUpdate
 */
#define IAP2_MSG_ID_HOLD_STATUS_UPDATE                                0x415F
/**
 * Message: InitiateCall
 */
#define IAP2_MSG_ID_INITIATE_CALL                                     0x415A
/**
 * Message: MergeCalls
 */
#define IAP2_MSG_ID_MERGE_CALLS                                       0x415E
/**
 * Message: MuteStatusUpdate
 */
#define IAP2_MSG_ID_MUTE_STATUS_UPDATE                                0x4160
/**
 * Message: SendDTMF
 */
#define IAP2_MSG_ID_SEND_DTMF                                         0x4161
/**
 * Message: StartCallStateUpdates
 */
#define IAP2_MSG_ID_START_CALL_STATE_UPDATES                          0x4154
/**
 * Message: StartCommunicationsUpdates
 */
#define IAP2_MSG_ID_START_COMMUNICATIONS_UPDATES                      0x4157
/**
 * Message: StartListUpdates
 */
#define IAP2_MSG_ID_START_LIST_UPDATES                                0x4170
/**
 * Message: StopCallStateUpdates
 */
#define IAP2_MSG_ID_STOP_CALL_STATE_UPDATES                           0x4156
/**
 * Message: StopCommunicationsUpdates
 */
#define IAP2_MSG_ID_STOP_COMMUNICATIONS_UPDATES                       0x4159
/**
 * Message: StopListUpdates
 */
#define IAP2_MSG_ID_STOP_LIST_UPDATES                                 0x4172
/**
 * Message: SwapCalls
 */
#define IAP2_MSG_ID_SWAP_CALLS                                        0x415D
/**
 * Message: CallStateUpdate
 */
#define IAP2_MSG_ID_CALL_STATE_UPDATE                                 0x4155
/**
 * Message: CommunicationsUpdate
 */
#define IAP2_MSG_ID_COMMUNICATIONS_UPDATE                             0x4158
/**
 * Message: ListUpdate
 */
#define IAP2_MSG_ID_LIST_UPDATE                                       0x4171
/**
 * Message: RequestDeviceAuthenticationCertificate
 */
#define IAP2_MSG_ID_REQUEST_DEVICE_AUTHENTICATION_CERTIFICATE         0xAA10
/**
 * Message: RequestDeviceAuthenticationChallengeResponse
 */
#define IAP2_MSG_ID_REQUEST_DEVICE_AUTHENTICATION_CHALLENGE_RESPONSE  0xAA12
/**
 * Message: DeviceAuthenticationFailed
 */
#define IAP2_MSG_ID_DEVICE_AUTHENTICATION_FAILED                      0xAA14
/**
 * Message: DeviceAuthenticationSucceeded
 */
#define IAP2_MSG_ID_DEVICE_AUTHENTICATION_SUCCEEDED                   0xAA15
/**
 * Message: DeviceAuthenticationCertificate
 */
#define IAP2_MSG_ID_DEVICE_AUTHENTICATION_CERTIFICATE                 0xAA11
/**
 * Message: DeviceAuthenticationResponse
 */
#define IAP2_MSG_ID_DEVICE_AUTHENTICATION_RESPONSE                    0xAA13
/**
 * Message: DeviceInformationUpdate
 */
#define IAP2_MSG_ID_DEVICE_INFORMATION_UPDATE                         0x4E09
/**
 * Message: DeviceLanguageUpdate
 */
#define IAP2_MSG_ID_DEVICE_LANGUAGE_UPDATE                            0x4E0A
/**
 * Message: DeviceTimeUpdate
 */
#define IAP2_MSG_ID_DEVICE_TIME_UPDATE                                0x4E0B
/**
 * Message: DeviceUUIDUpdate
 */
#define IAP2_MSG_ID_DEVICE_UUID_UPDATE                                0x4E0C
/**
 * Message: WirelessCarPlayUpdate
 */
#define IAP2_MSG_ID_WIRELESS_CAR_PLAY_UPDATE                          0x4E0D
/**
 * Message: DeviceTransportIdentifierNotification
 */
#define IAP2_MSG_ID_DEVICE_TRANSPORT_IDENTIFIER_NOTIFICATION          0x4E0E
/**
 * Message: StatusExternalAccessoryProtocolSession
 */
#define IAP2_MSG_ID_STATUS_EXTERNAL_ACCESSORY_PROTOCOL_SESSION        0xEA03
/**
 * Message: StartExternalAccessoryProtocolSession
 */
#define IAP2_MSG_ID_START_EXTERNAL_ACCESSORY_PROTOCOL_SESSION         0xEA00
/**
 * Message: StopExternalAccessoryProtocolSession
 */
#define IAP2_MSG_ID_STOP_EXTERNAL_ACCESSORY_PROTOCOL_SESSION          0xEA01
/**
 * Message: StartHID
 */
#define IAP2_MSG_ID_START_HID                                         0x6800
/**
 * Message: AccessoryHIDReport
 */
#define IAP2_MSG_ID_ACCESSORY_HID_REPORT                              0x6802
/**
 * Message: StopHID
 */
#define IAP2_MSG_ID_STOP_HID                                          0x6803
/**
 * Message: DeviceHIDReport
 */
#define IAP2_MSG_ID_DEVICE_HID_REPORT                                 0x6801
/**
 * Message: StartNativeHID
 */
#define IAP2_MSG_ID_START_NATIVE_HID                                  0x6806
/**
 * Message: LocationInformation
 */
#define IAP2_MSG_ID_LOCATION_INFORMATION                              0xFFFB
/**
 * Message: GPRMCDataStatusValuesNotification
 */
#define IAP2_MSG_ID_GPRMC_DATA_STATUS_VALUES_NOTIFICATION             0xFFF0
/**
 * Message: StartLocationInformation
 */
#define IAP2_MSG_ID_START_LOCATION_INFORMATION                        0xFFFA
/**
 * Message: StopLocationInformation
 */
#define IAP2_MSG_ID_STOP_LOCATION_INFORMATION                         0xFFFC
/**
 * Message: PlayMediaLibraryCollection
 */
#define IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_COLLECTION                     0x4C08
/**
 * Message: PlayMediaLibraryCurrentSelection
 */
#define IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_CURRENT_SELECTION              0x4C06
/**
 * Message: PlayMediaLibraryItems
 */
#define IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_ITEMS                          0x4C07
/**
 * Message: PlayMediaLibrarySpecial
 */
#define IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_SPECIAL                        0x4C09
/**
 * Message: StartMediaLibraryInformation
 */
#define IAP2_MSG_ID_START_MEDIA_LIBRARY_INFORMATION                   0x4C00
/**
 * Message: StartMediaLibraryUpdates
 */
#define IAP2_MSG_ID_START_MEDIA_LIBRARY_UPDATES                       0x4C03
/**
 * Message: StopMediaLibraryInformation
 */
#define IAP2_MSG_ID_STOP_MEDIA_LIBRARY_INFORMATION                    0x4C02
/**
 * Message: StopMediaLibraryUpdates
 */
#define IAP2_MSG_ID_STOP_MEDIA_LIBRARY_UPDATES                        0x4C05
/**
 * Message: MediaLibraryInformation
 */
#define IAP2_MSG_ID_MEDIA_LIBRARY_INFORMATION                         0x4C01
/**
 * Message: MediaLibraryUpdate
 */
#define IAP2_MSG_ID_MEDIA_LIBRARY_UPDATE                              0x4C04
/**
 * Message: SetNowPlayingInformation
 */
#define IAP2_MSG_ID_SET_NOW_PLAYING_INFORMATION                       0x5003
/**
 * Message: StartNowPlayingUpdates
 */
#define IAP2_MSG_ID_START_NOW_PLAYING_UPDATES                         0x5000
/**
 * Message: StopNowPlayingUpdates
 */
#define IAP2_MSG_ID_STOP_NOW_PLAYING_UPDATES                          0x5002
/**
 * Message: NowPlayingUpdateParameter
 */
#define IAP2_MSG_ID_NOW_PLAYING_UPDATE_PARAMETER                      0x5001
/**
 * Message: StartPowerUpdates
 */
#define IAP2_MSG_ID_START_POWER_UPDATES                               0xAE00
/**
 * Message: StopPowerUpdates
 */
#define IAP2_MSG_ID_STOP_POWER_UPDATES                                0xAE02
/**
 * Message: PowerSourceUpdate
 */
#define IAP2_MSG_ID_POWER_SOURCE_UPDATE                               0xAE03
/**
 * Message: PowerUpdate
 */
#define IAP2_MSG_ID_POWER_UPDATE                                      0xAE01
/**
 * Message: StartTelephonyCallStateInformation
 * The Message StartTelephonyCallStateInformation is Deprecated, Don't use it. Kindly refer the Apple Specificaiton.
 */
#define IAP2_MSG_ID_START_TELEPHONY_CALL_STATE_INFORMATION            0x4154
/**
 * Message: StartTelephonyUpdates
 * The Message StartTelephonyUpdates is Deprecated, Don't use it. Kindly refer the Apple Specificaiton.
 */
#define IAP2_MSG_ID_START_TELEPHONY_UPDATES                           0x4157
/**
 * Message: StopTelephonyCallStateInformation
 * The Message StopTelephonyCallStateInformation is Deprecated, Don't use it. Kindly refer the Apple Specificaiton.
 */
#define IAP2_MSG_ID_STOP_TELEPHONY_CALL_STATE_INFORMATION             0x4156
/**
 * Message: StopTelephonyUpdates
 * The Message StopTelephonyUpdates is Deprecated, Don't use it. Kindly refer the Apple Specificaiton.
 */
#define IAP2_MSG_ID_STOP_TELEPHONY_UPDATES                            0x4159
/**
 * Message: TelephonyCallStateInformation
 * The Message TelephonyCallStateInformation is Deprecated, Don't use it. Kindly refer the Apple Specificaiton.
 */
#define IAP2_MSG_ID_TELEPHONY_CALL_STATE_INFORMATION                  0x4155
/**
 * Message: TelephonyUpdate
 * The Message TelephonyUpdate is Deprecated, Don't use it. Kindly refer the Apple Specificaiton.
 */
#define IAP2_MSG_ID_TELEPHONY_UPDATE                                  0x4158
/**
 * Message: StartUSBDeviceModeAudio
 */
#define IAP2_MSG_ID_START_USB_DEVICE_MODE_AUDIO                       0xDA00
/**
 * Message: StopUSBDeviceModeAudio
 */
#define IAP2_MSG_ID_STOP_USB_DEVICE_MODE_AUDIO                        0xDA02
/**
 * Message: USBDeviceModeAudioInformation
 */
#define IAP2_MSG_ID_USB_DEVICE_MODE_AUDIO_INFORMATION                 0xDA01
/**
 * Message: VehicleStatusUpdate
 */
#define IAP2_MSG_ID_VEHICLE_STATUS_UPDATE                             0xA101
/**
 * Message: StartVehicleStatusUpdates
 */
#define IAP2_MSG_ID_START_VEHICLE_STATUS_UPDATES                      0xA100
/**
 * Message: StopVehicleStatusUpdates
 */
#define IAP2_MSG_ID_STOP_VEHICLE_STATUS_UPDATES                       0xA102
/**
 * Message: RequestVoiceOverActivateCursor
 */
#define IAP2_MSG_ID_REQUEST_VOICE_OVER_ACTIVATE_CURSOR                0x5602
/**
 * Message: RequestVoiceOverConfiguration
 */
#define IAP2_MSG_ID_REQUEST_VOICE_OVER_CONFIGURATION                  0x560E
/**
 * Message: RequestVoiceOverMoveCursor
 */
#define IAP2_MSG_ID_REQUEST_VOICE_OVER_MOVE_CURSOR                    0x5601
/**
 * Message: RequestVoiceOverPauseText
 */
#define IAP2_MSG_ID_REQUEST_VOICE_OVER_PAUSE_TEXT                     0x5608
/**
 * Message: RequestVoiceOverResumeText
 */
#define IAP2_MSG_ID_REQUEST_VOICE_OVER_RESUME_TEXT                    0x5609
/**
 * Message: RequestVoiceOverScrollPage
 */
#define IAP2_MSG_ID_REQUEST_VOICE_OVER_SCROLL_PAGE                    0x5603
/**
 * Message: RequestVoiceOverSpeakText
 */
#define IAP2_MSG_ID_REQUEST_VOICE_OVER_SPEAK_TEXT                     0x5606
/**
 * Message: StartVoiceOver
 */
#define IAP2_MSG_ID_START_VOICE_OVER                                  0x5612
/**
 * Message: StartVoiceOverCursorUpdates
 */
#define IAP2_MSG_ID_START_VOICE_OVER_CURSOR_UPDATES                   0x560F
/**
 * Message: StartVoiceOverUpdates
 */
#define IAP2_MSG_ID_START_VOICE_OVER_UPDATES                          0x560B
/**
 * Message: StopVoiceOver
 */
#define IAP2_MSG_ID_STOP_VOICE_OVER                                   0x5613
/**
 * Message: StopVoiceOverCursorUpdates
 */
#define IAP2_MSG_ID_STOP_VOICE_OVER_CURSOR_UPDATES                    0x5611
/**
 * Message: StopVoiceOverUpdates
 */
#define IAP2_MSG_ID_STOP_VOICE_OVER_UPDATES                           0x560D
/**
 * Message: VoiceOverCursorUpdate
 */
#define IAP2_MSG_ID_VOICE_OVER_CURSOR_UPDATE                          0x5610
/**
 * Message: VoiceOverUpdate
 */
#define IAP2_MSG_ID_VOICE_OVER_UPDATE                                 0x560C
/**
 * Message: AccessoryWiFiConfigurationInformation
 */
#define IAP2_MSG_ID_ACCESSORY_WI_FI_CONFIGURATION_INFORMATION         0x5703
/**
 * Message: RequestWiFiInformation
 */
#define IAP2_MSG_ID_REQUEST_WI_FI_INFORMATION                         0x5700
/**
 * Message: RequestAccessoryWiFiConfigurationInformation
 */
#define IAP2_MSG_ID_REQUEST_ACCESSORY_WI_FI_CONFIGURATION_INFORMATION 0x5702
/**
 * Message: WiFiInformation
 */
#define IAP2_MSG_ID_WI_FI_INFORMATION                                 0x5701

/**
 * Parameter: AuthenticationSerialNumber, message:AccessoryAuthenticationSerialNumber
 */
#define IAP2_PAR_ID_AUTHENTICATION_SERIAL_NUMBER_0xAA06                                                  0
/**
 * Parameter: AuthenticationCertificate, message:AuthenticationCertificate
 */
#define IAP2_PAR_ID_AUTHENTICATION_CERTIFICATE_0xAA01                                                    0
/**
 * Parameter: AuthenticationResponse, message:AuthenticationResponse
 */
#define IAP2_PAR_ID_AUTHENTICATION_RESPONSE_0xAA03                                                       0
/**
 * Parameter: RequestAuthenticationCertificateSerialNumber, message:RequestAuthenticationCertificate
 */
#define IAP2_PAR_ID_REQUEST_AUTHENTICATION_CERTIFICATE_SERIAL_NUMBER_0xAA00                              0
/**
 * Parameter: AuthenticationChallenge, message:RequestAuthenticationChallengeResponse
 */
#define IAP2_PAR_ID_AUTHENTICATION_CHALLENGE_0xAA02                                                      0
/**
 * Parameter: AccessoryFirmwareVersion, message:IdentificationInformation
 */
#define IAP2_PAR_ID_ACCESSORY_FIRMWARE_VERSION_0x1D01                                                    4
/**
 * Parameter: AccessoryHardwareVersion, message:IdentificationInformation
 */
#define IAP2_PAR_ID_ACCESSORY_HARDWARE_VERSION_0x1D01                                                    5
/**
 * Parameter: AccessoryManufacturer, message:IdentificationInformation
 */
#define IAP2_PAR_ID_ACCESSORY_MANUFACTURER_0x1D01                                                        2
/**
 * Parameter: AccessoryModelIdentifier, message:IdentificationInformation
 */
#define IAP2_PAR_ID_ACCESSORY_MODEL_IDENTIFIER_0x1D01                                                    1
/**
 * Parameter: AccessoryName, message:IdentificationInformation
 */
#define IAP2_PAR_ID_ACCESSORY_NAME_0x1D01                                                                0
/**
 * Parameter: AccessorySerialNumber, message:IdentificationInformation
 */
#define IAP2_PAR_ID_ACCESSORY_SERIAL_NUMBER_0x1D01                                                       3
/**
 * Parameter: AppMatchTeamID, message:IdentificationInformation
 */
#define IAP2_PAR_ID_APP_MATCH_TEAM_ID_0x1D01                                                             11
/**
 * Parameter: BluetoothHIDComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_BLUETOOTH_HID_COMPONENT_0x1D01                                                       29
/**
 * Parameter: BluetoothTransportComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_0x1D01                                                 17
/**
 * Parameter: CurrentLanguage, message:IdentificationInformation
 */
#define IAP2_PAR_ID_CURRENT_LANGUAGE_0x1D01                                                              12
/**
 * Parameter: ExternalAccessoryProtocol, message:IdentificationInformation
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_0x1D01                                                   10
/**
 * Parameter: iAP2HIDComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_I_AP2HIDCOMPONENT_0x1D01                                                             18
/**
 * Parameter: LocationInformationComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_0x1D01                                                22
/**
 * Parameter: MaximumCurrentDrawnFromDevice, message:IdentificationInformation
 */
#define IAP2_PAR_ID_MAXIMUM_CURRENT_DRAWN_FROM_DEVICE_0x1D01                                             9
/**
 * Parameter: MessagesRecievedfromDevice, message:IdentificationInformation
 */
#define IAP2_PAR_ID_MESSAGES_RECIEVEDFROM_DEVICE_0x1D01                                                  7
/**
 * Parameter: MessagesSentByAccessory, message:IdentificationInformation
 */
#define IAP2_PAR_ID_MESSAGES_SENT_BY_ACCESSORY_0x1D01                                                    6
/**
 * Parameter: PowerProvidingCapability, message:IdentificationInformation
 */
#define IAP2_PAR_ID_POWER_PROVIDING_CAPABILITY_0x1D01                                                    8
/**
 * Parameter: SerialTransportComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_SERIAL_TRANSPORT_COMPONENT_0x1D01                                                    14
/**
 * Parameter: SupportedLanguage, message:IdentificationInformation
 */
#define IAP2_PAR_ID_SUPPORTED_LANGUAGE_0x1D01                                                            13
/**
 * Parameter: USBDeviceTransportComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_USB_DEVICE_TRANSPORT_COMPONENT_0x1D01                                                15
/**
 * Parameter: USBHostHIDComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_USB_HOST_HIDCOMPONENT_0x1D01                                                         23
/**
 * Parameter: USBHostTransportComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_USB_HOST_TRANSPORT_COMPONENT_0x1D01                                                  16
/**
 * Parameter: VehicleInformationComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_VEHICLE_INFORMATION_COMPONENT_0x1D01                                                 20
/**
 * Parameter: RouteGuidanceDisplayComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_0x1D01                                              30
/**
 * Parameter: VehicleStatusComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_VEHICLE_STATUS_COMPONENT_0x1D01                                                      21
/**
 * Parameter: WirelessCarPlayTransportComponent, message:IdentificationInformation
 */
#define IAP2_PAR_ID_WIRELESS_CAR_PLAY_TRANSPORT_COMPONENT_0x1D01                                         24
/**
 * Parameter: AccessoryFirmwareVersion, message:IdentificationInformationUpdate
 */
#define IAP2_PAR_ID_ACCESSORY_FIRMWARE_VERSION_0x1D06                                                    4
/**
 * Parameter: AccessoryHardwareVersion, message:IdentificationInformationUpdate
 */
#define IAP2_PAR_ID_ACCESSORY_HARDWARE_VERSION_0x1D06                                                    5
/**
 * Parameter: AccessoryManufacturer, message:IdentificationInformationUpdate
 */
#define IAP2_PAR_ID_ACCESSORY_MANUFACTURER_0x1D06                                                        2
/**
 * Parameter: AccessoryModelIdentifier, message:IdentificationInformationUpdate
 */
#define IAP2_PAR_ID_ACCESSORY_MODEL_IDENTIFIER_0x1D06                                                    1
/**
 * Parameter: AccessoryName, message:IdentificationInformationUpdate
 */
#define IAP2_PAR_ID_ACCESSORY_NAME_0x1D06                                                                0
/**
 * Parameter: AccessorySerialNumber, message:IdentificationInformationUpdate
 */
#define IAP2_PAR_ID_ACCESSORY_SERIAL_NUMBER_0x1D06                                                       3
/**
 * Parameter: CurrentLanguage, message:IdentificationInformationUpdate
 */
#define IAP2_PAR_ID_CURRENT_LANGUAGE_0x1D06                                                              6
/**
 * Parameter: AccessoryFirmwareVersion, message:IdentificationRejected
 */
#define IAP2_PAR_ID_ACCESSORY_FIRMWARE_VERSION_0x1D03                                                    4
/**
 * Parameter: AccessoryHardwareVersion, message:IdentificationRejected
 */
#define IAP2_PAR_ID_ACCESSORY_HARDWARE_VERSION_0x1D03                                                    5
/**
 * Parameter: AccessoryManufacturer, message:IdentificationRejected
 */
#define IAP2_PAR_ID_ACCESSORY_MANUFACTURER_0x1D03                                                        2
/**
 * Parameter: AccessoryModelIdentifier, message:IdentificationRejected
 */
#define IAP2_PAR_ID_ACCESSORY_MODEL_IDENTIFIER_0x1D03                                                    1
/**
 * Parameter: AccessoryName, message:IdentificationRejected
 */
#define IAP2_PAR_ID_ACCESSORY_NAME_0x1D03                                                                0
/**
 * Parameter: AccessorySerialNumber, message:IdentificationRejected
 */
#define IAP2_PAR_ID_ACCESSORY_SERIAL_NUMBER_0x1D03                                                       3
/**
 * Parameter: AppMatchTeamID, message:IdentificationRejected
 */
#define IAP2_PAR_ID_APP_MATCH_TEAM_ID_0x1D03                                                             11
/**
 * Parameter: BluetoothHIDComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_BLUETOOTH_HID_COMPONENT_0x1D03                                                       29
/**
 * Parameter: BluetoothTransportComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_0x1D03                                                 17
/**
 * Parameter: CurrentLanguage, message:IdentificationRejected
 */
#define IAP2_PAR_ID_CURRENT_LANGUAGE_0x1D03                                                              12
/**
 * Parameter: iAP2HIDComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_I_AP2HIDCOMPONENT_0x1D03                                                             18
/**
 * Parameter: LocationInformationComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_0x1D03                                                22
/**
 * Parameter: MaximumCurrentDrawnFromDevice, message:IdentificationRejected
 */
#define IAP2_PAR_ID_MAXIMUM_CURRENT_DRAWN_FROM_DEVICE_0x1D03                                             9
/**
 * Parameter: MessagesRecievedfromDevice, message:IdentificationRejected
 */
#define IAP2_PAR_ID_MESSAGES_RECIEVEDFROM_DEVICE_0x1D03                                                  7
/**
 * Parameter: MessagesSentByAccessory, message:IdentificationRejected
 */
#define IAP2_PAR_ID_MESSAGES_SENT_BY_ACCESSORY_0x1D03                                                    6
/**
 * Parameter: PowerProvidingCapability, message:IdentificationRejected
 */
#define IAP2_PAR_ID_POWER_PROVIDING_CAPABILITY_0x1D03                                                    8
/**
 * Parameter: PowerSourceType, message:IdentificationRejected
 * The Parameter PowerSourceType is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_POWER_SOURCE_TYPE_0x1D03                                                             8
/**
 * Parameter: PreferredAppBundleSeedIdentifier, message:IdentificationRejected
 * The Parameter PreferredAppBundleSeedIdentifier is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_PREFERRED_APP_BUNDLE_SEED_IDENTIFIER_0x1D03                                          11
/**
 * Parameter: SerialTransportComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_SERIAL_TRANSPORT_COMPONENT_0x1D03                                                    14
/**
 * Parameter: SupportedExternalAccessoryProtocol, message:IdentificationRejected
 */
#define IAP2_PAR_ID_SUPPORTED_EXTERNAL_ACCESSORY_PROTOCOL_0x1D03                                         10
/**
 * Parameter: SupportedLanguage, message:IdentificationRejected
 */
#define IAP2_PAR_ID_SUPPORTED_LANGUAGE_0x1D03                                                            13
/**
 * Parameter: USBDeviceTransportComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_USB_DEVICE_TRANSPORT_COMPONENT_0x1D03                                                15
/**
 * Parameter: USBHostHIDComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_USB_HOST_HIDCOMPONENT_0x1D03                                                         23
/**
 * Parameter: USBHostTransportComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_USB_HOST_TRANSPORT_COMPONENT_0x1D03                                                  16
/**
 * Parameter: VehicleInformationComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_VEHICLE_INFORMATION_COMPONENT_0x1D03                                                 20
/**
 * Parameter: VehicleStatusComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_VEHICLE_STATUS_COMPONENT_0x1D03                                                      21
/**
 * Parameter: WirelessCarPlayTransportComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_WIRELESS_CAR_PLAY_TRANSPORT_COMPONENT_0x1D03                                         24
/**
 * Parameter: RouteGuidanceDisplayComponent, message:IdentificationRejected
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_0x1D03                                              30
/**
 * Parameter: AppBundleID, message:RequestAppLaunch
 */
#define IAP2_PAR_ID_APP_BUNDLE_ID_0xEA02                                                                 0
/**
 * Parameter: LaunchAlert, message:RequestAppLaunch
 */
#define IAP2_PAR_ID_LAUNCH_ALERT_0xEA02                                                                  1
/**
 * Parameter: BluetoothTransportComponentIdentifier, message:OOBBTPairingAccessoryInformation
 */
#define IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_IDENTIFIER_0x00B1                                      0
/**
 * Parameter: DeviceClass, message:OOBBTPairingAccessoryInformation
 */
#define IAP2_PAR_ID_DEVICE_CLASS_0x00B1                                                                  1
/**
 * Parameter: ResultCode, message:OOBBTPairingCompletionInformation
 */
#define IAP2_PAR_ID_RESULT_CODE_0x00B3                                                                   0
/**
 * Parameter: AppleDeviceMACAddress, message:OOBBTPairingLinkKeyInformation
 */
#define IAP2_PAR_ID_APPLE_DEVICE_MAC_ADDRESS_0x00B2                                                      1
/**
 * Parameter: LinkKey, message:OOBBTPairingLinkKeyInformation
 */
#define IAP2_PAR_ID_LINK_KEY_0x00B2                                                                      0
/**
 * Parameter: RouteGuidanceDisplayComponentID, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5202                                           0
/**
 * Parameter: Index, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_INDEX_0x5202                                                                         1
/**
 * Parameter: ManeuverDescription, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_MANEUVER_DESCRIPTION_0x5202                                                          2
/**
 * Parameter: ManeuverType, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_MANEUVER_TYPE_0x5202                                                                 3
/**
 * Parameter: AfterManeuverRoadName, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_AFTER_MANEUVER_ROAD_NAME_0x5202                                                      4
/**
 * Parameter: DistanceBetweenManeuver, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_DISTANCE_BETWEEN_MANEUVER_0x5202                                                     5
/**
 * Parameter: DistanceBetweenManeuverDisplayStr, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_DISTANCE_BETWEEN_MANEUVER_DISPLAY_STR_0x5202                                         6
/**
 * Parameter: DistanceBetweenManeuverDisplayUnits, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_DISTANCE_BETWEEN_MANEUVER_DISPLAY_UNITS_0x5202                                       7
/**
 * Parameter: DrivingSide, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_DRIVING_SIDE_0x5202                                                                  8
/**
 * Parameter: JunctionType, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_JUNCTION_TYPE_0x5202                                                                 9
/**
 * Parameter: JunctionElementAngle, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_JUNCTION_ELEMENT_ANGLE_0x5202                                                        10
/**
 * Parameter: JunctionElementExitAngle, message:RouteGuidanceManeuverUpdate
 */
#define IAP2_PAR_ID_JUNCTION_ELEMENT_EXIT_ANGLE_0x5202                                                   11
/**
 * Parameter: RouteGuidanceDisplayComponentID, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5201                                           0
/**
 * Parameter: CurrentRoadName, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_CURRENT_ROAD_NAME_0x5201                                                             3
/**
 * Parameter: DestinationName, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_DESTINATION_NAME_0x5201                                                              4
/**
 * Parameter: EstimatedTimeOfArrival, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_ESTIMATED_TIME_OF_ARRIVAL_0x5201                                                     5
/**
 * Parameter: TimeRemainingToDestination, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_TIME_REMAINING_TO_DESTINATION_0x5201                                                 6
/**
 * Parameter: DistanceRemaining, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_DISTANCE_REMAINING_0x5201                                                            7
/**
 * Parameter: DistanceRemainingDisplayStr, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_DISTANCE_REMAINING_DISPLAY_STR_0x5201                                                8
/**
 * Parameter: DistanceToNextManeuver, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_DISTANCE_TO_NEXT_MANEUVER_0x5201                                                     10
/**
 * Parameter: DistanceToNextManeuverDisplayStr, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_DISTANCE_TO_NEXT_MANEUVER_DISPLAY_STR_0x5201                                         11
/**
 * Parameter: DistanceToNextManeuverDisplayUnits, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_DISTANCE_TO_NEXT_MANEUVER_DISPLAY_UNITS_0x5201                                       12
/**
 * Parameter: DistanceRemainingDisplayUnits, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_DISTANCE_REMAINING_DISPLAY_UNITS_0x5201                                              9
/**
 * Parameter: RouteGuidanceState, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_STATE_0x5201                                                          1
/**
 * Parameter: ManeuverState, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_MANEUVER_STATE_0x5201                                                                2
/**
 * Parameter: RouteGuidanceManeuverCurrentList, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_MANEUVER_CURRENT_LIST_0x5201                                          13
/**
 * Parameter: RouteGuidanceManeuverCount, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_MANEUVER_COUNT_0x5201                                                 14
/**
 * Parameter: RouteGuidanceVisiblelnApp, message:RouteGuidanceUpdate
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_VISIBLELN_APP_0x5201                                                  15
/**
 * Parameter: RouteGuidanceDisplayComponentID, message:StartRouteGuidanceUpdate
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5200                                           0
/**
 * Parameter: RouteGuidanceDisplayComponentID, message:StopRouteGuidanceUpdate
 */
#define IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5203                                           0
/**
 * Parameter: IsEnabled, message:AssistiveTouchInformation
 */
#define IAP2_PAR_ID_IS_ENABLED_0x5403                                                                    0
/**
 * Parameter: BluetoothComponentStatus, message:BluetoothComponentInformation
 */
#define IAP2_PAR_ID_BLUETOOTH_COMPONENT_STATUS_0x4E01                                                    0
/**
 * Parameter: BluetoothComponentProfiles, message:BluetoothConnectionUpdate
 */
#define IAP2_PAR_ID_BLUETOOTH_COMPONENT_PROFILES_0x4E04                                                  1
/**
 * Parameter: BluetoothTransportComponentIdentifier, message:BluetoothConnectionUpdate
 */
#define IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_IDENTIFIER_0x4E04                                      0
/**
 * Parameter: BluetoothTransportComponentIdentifier, message:StartBluetoothConnectionUpdates
 */
#define IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_IDENTIFIER_0x4E03                                      0
/**
 * Parameter: AcceptAction, message:AcceptCall
 */
#define IAP2_PAR_ID_ACCEPT_ACTION_0x415B                                                                 0
/**
 * Parameter: CallUUID, message:AcceptCall
 */
#define IAP2_PAR_ID_CALL_UUID_0x415B                                                                     1
/**
 * Parameter: AddressBookID, message:CallStateUpdate
 */
#define IAP2_PAR_ID_ADDRESS_BOOK_ID_0x4155                                                               6
/**
 * Parameter: CallUUID, message:CallStateUpdate
 */
#define IAP2_PAR_ID_CALL_UUID_0x4155                                                                     4
/**
 * Parameter: ConferenceGroup, message:CallStateUpdate
 */
#define IAP2_PAR_ID_CONFERENCE_GROUP_0x4155                                                              10
/**
 * Parameter: Direction, message:CallStateUpdate
 */
#define IAP2_PAR_ID_DIRECTION_0x4155                                                                     3
/**
 * Parameter: DisconnectReason, message:CallStateUpdate
 */
#define IAP2_PAR_ID_DISCONNECT_REASON_0x4155                                                             11
/**
 * Parameter: DisplayName, message:CallStateUpdate
 */
#define IAP2_PAR_ID_DISPLAY_NAME_0x4155                                                                  1
/**
 * Parameter: IsConferenced, message:CallStateUpdate
 */
#define IAP2_PAR_ID_IS_CONFERENCED_0x4155                                                                9
/**
 * Parameter: Label, message:CallStateUpdate
 */
#define IAP2_PAR_ID_LABEL_0x4155                                                                         7
/**
 * Parameter: RemoteID, message:CallStateUpdate
 */
#define IAP2_PAR_ID_REMOTE_ID_0x4155                                                                     0
/**
 * Parameter: Service, message:CallStateUpdate
 */
#define IAP2_PAR_ID_SERVICE_0x4155                                                                       8
/**
 * Parameter: Status, message:CallStateUpdate
 */
#define IAP2_PAR_ID_STATUS_0x4155                                                                        2
/**
 * Parameter: StartTimestamp, message:CallStateUpdate
 */
#define IAP2_PAR_ID_START_TIMESTAMP_0x4155                                                               12
/**
 * Parameter: AirplaneModeStatus, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_AIRPLANE_MODE_STATUS_0x4158                                                          2
/**
 * Parameter: CarrierName, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_CARRIER_NAME_0x4158                                                                  4
/**
 * Parameter: CellularSupported, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_CELLULAR_SUPPORTED_0x4158                                                            5
/**
 * Parameter: CurrentCallCount, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_CURRENT_CALL_COUNT_0x4158                                                            10
/**
 * Parameter: EndAndAcceptAvailable, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_END_AND_ACCEPT_AVAILABLE_0x4158                                                      13
/**
 * Parameter: FaceTimeAudioEnabled, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_FACE_TIME_AUDIO_ENABLED_0x4158                                                       7
/**
 * Parameter: FaceTimeVideoEnabled, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_FACE_TIME_VIDEO_ENABLED_0x4158                                                       8
/**
 * Parameter: HoldAndAcceptAvailable, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_HOLD_AND_ACCEPT_AVAILABLE_0x4158                                                     14
/**
 * Parameter: HoldAvailable, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_HOLD_AVAILABLE_0x4158                                                                17
/**
 * Parameter: InitiateCallAvailable, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_INITIATE_CALL_AVAILABLE_0x4158                                                       12
/**
 * Parameter: MergeAvailable, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_MERGE_AVAILABLE_0x4158                                                               16
/**
 * Parameter: MuteStatus, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_MUTE_STATUS_0x4158                                                                   9
/**
 * Parameter: NewVoicemailCount, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_NEW_VOICEMAIL_COUNT_0x4158                                                           11
/**
 * Parameter: RegistrationStatus, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_REGISTRATION_STATUS_0x4158                                                           1
/**
 * Parameter: SignalStrength, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_SIGNAL_STRENGTH_0x4158                                                               0
/**
 * Parameter: SwapAvailable, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_SWAP_AVAILABLE_0x4158                                                                15
/**
 * Parameter: TelephonyEnabled, message:CommunicationsUpdate
 */
#define IAP2_PAR_ID_TELEPHONY_ENABLED_0x4158                                                             6
/**
 * Parameter: CallUUID, message:EndCall
 */
#define IAP2_PAR_ID_CALL_UUID_0x415C                                                                     1
/**
 * Parameter: EndAction, message:EndCall
 */
#define IAP2_PAR_ID_END_ACTION_0x415C                                                                    0
/**
 * Parameter: CallUUID, message:HoldStatusUpdate
 */
#define IAP2_PAR_ID_CALL_UUID_0x415F                                                                     1
/**
 * Parameter: HoldStatusUpdate, message:HoldStatusUpdate
 */
#define IAP2_PAR_ID_HOLD_STATUS_UPDATE_0x415F                                                            0
/**
 * Parameter: AddressBookID, message:InitiateCall
 */
#define IAP2_PAR_ID_ADDRESS_BOOK_ID_0x415A                                                               3
/**
 * Parameter: DestinationID, message:InitiateCall
 */
#define IAP2_PAR_ID_DESTINATION_ID_0x415A                                                                1
/**
 * Parameter: Service, message:InitiateCall
 */
#define IAP2_PAR_ID_SERVICE_0x415A                                                                       2
/**
 * Parameter: Type, message:InitiateCall
 */
#define IAP2_PAR_ID_TYPE_0x415A                                                                          0
/**
 * Parameter: FavoritesList, message:ListUpdate
 */
#define IAP2_PAR_ID_FAVORITES_LIST_0x4171                                                                6
/**
 * Parameter: FavoritesListAvailable, message:ListUpdate
 */
#define IAP2_PAR_ID_FAVORITES_LIST_AVAILABLE_0x4171                                                      5
/**
 * Parameter: FavoritesListCount, message:ListUpdate
 */
#define IAP2_PAR_ID_FAVORITES_LIST_COUNT_0x4171                                                          7
/**
 * Parameter: RecentsList, message:ListUpdate
 */
#define IAP2_PAR_ID_RECENTS_LIST_0x4171                                                                  1
/**
 * Parameter: RecentsListAvailable, message:ListUpdate
 */
#define IAP2_PAR_ID_RECENTS_LIST_AVAILABLE_0x4171                                                        0
/**
 * Parameter: RecentsListCount, message:ListUpdate
 */
#define IAP2_PAR_ID_RECENTS_LIST_COUNT_0x4171                                                            2
/**
 * Parameter: MuteStatus, message:MuteStatusUpdate
 */
#define IAP2_PAR_ID_MUTE_STATUS_0x4160                                                                   0
/**
 * Parameter: CallUUID, message:SendDTMF
 */
#define IAP2_PAR_ID_CALL_UUID_0x4161                                                                     1
/**
 * Parameter: Tone, message:SendDTMF
 */
#define IAP2_PAR_ID_TONE_0x4161                                                                          0
/**
 * Parameter: AddressBookID, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_ADDRESS_BOOK_ID_0x4154                                                               6
/**
 * Parameter: CallUUID, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_CALL_UUID_0x4154                                                                     4
/**
 * Parameter: ConferenceGroup, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_CONFERENCE_GROUP_0x4154                                                              10
/**
 * Parameter: Direction, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_DIRECTION_0x4154                                                                     3
/**
 * Parameter: DisconnectReason, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_DISCONNECT_REASON_0x4154                                                             11
/**
 * Parameter: DisplayName, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_DISPLAY_NAME_0x4154                                                                  1
/**
 * Parameter: IsConferenced, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_IS_CONFERENCED_0x4154                                                                9
/**
 * Parameter: Label, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_LABEL_0x4154                                                                         7
/**
 * Parameter: RemoteID, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_REMOTE_ID_0x4154                                                                     0
/**
 * Parameter: Service, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_SERVICE_0x4154                                                                       8
/**
 * Parameter: Status, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_STATUS_0x4154                                                                        2
/**
 * Parameter: StartTimestamp, message:StartCallStateUpdates
 */
#define IAP2_PAR_ID_START_TIMESTAMP_0x4154                                                               12
/**
 * Parameter: AirplaneModeStatus, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_AIRPLANE_MODE_STATUS_0x4157                                                          2
/**
 * Parameter: CarrierName, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_CARRIER_NAME_0x4157                                                                  4
/**
 * Parameter: CellularSupported, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_CELLULAR_SUPPORTED_0x4157                                                            5
/**
 * Parameter: CurrentCallCount, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_CURRENT_CALL_COUNT_0x4157                                                            10
/**
 * Parameter: EndAndAcceptAvailable, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_END_AND_ACCEPT_AVAILABLE_0x4157                                                      13
/**
 * Parameter: FaceTimeAudioEnabled, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_FACE_TIME_AUDIO_ENABLED_0x4157                                                       7
/**
 * Parameter: FaceTimeVideoEnabled, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_FACE_TIME_VIDEO_ENABLED_0x4157                                                       8
/**
 * Parameter: HoldAndAcceptAvailable, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_HOLD_AND_ACCEPT_AVAILABLE_0x4157                                                     14
/**
 * Parameter: HoldAvailable, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_HOLD_AVAILABLE_0x4157                                                                17
/**
 * Parameter: InitiateCallAvailable, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_INITIATE_CALL_AVAILABLE_0x4157                                                       12
/**
 * Parameter: MergeAvailable, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_MERGE_AVAILABLE_0x4157                                                               16
/**
 * Parameter: MuteStatus, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_MUTE_STATUS_0x4157                                                                   9
/**
 * Parameter: NewVoiceMailCount, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_NEW_VOICE_MAIL_COUNT_0x4157                                                          11
/**
 * Parameter: RegistrationStatus, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_REGISTRATION_STATUS_0x4157                                                           1
/**
 * Parameter: SignalStrength, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_SIGNAL_STRENGTH_0x4157                                                               0
/**
 * Parameter: SwapAvailable, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_SWAP_AVAILABLE_0x4157                                                                15
/**
 * Parameter: TelephonyEnabled, message:StartCommunicationsUpdates
 */
#define IAP2_PAR_ID_TELEPHONY_ENABLED_0x4157                                                             6
/**
 * Parameter: FavoritesListMax, message:StartListUpdates
 */
#define IAP2_PAR_ID_FAVORITES_LIST_MAX_0x4170                                                            8
/**
 * Parameter: FavoritesListProperties, message:StartListUpdates
 */
#define IAP2_PAR_ID_FAVORITES_LIST_PROPERTIES_0x4170                                                     6
/**
 * Parameter: RecentListCombine, message:StartListUpdates
 */
#define IAP2_PAR_ID_RECENT_LIST_COMBINE_0x4170                                                           4
/**
 * Parameter: RecentListProperties, message:StartListUpdates
 */
#define IAP2_PAR_ID_RECENT_LIST_PROPERTIES_0x4170                                                        1
/**
 * Parameter: RecentsListMax, message:StartListUpdates
 */
#define IAP2_PAR_ID_RECENTS_LIST_MAX_0x4170                                                              3
/**
 * Parameter: DeviceCertificate, message:DeviceAuthenticationCertificate
 */
#define IAP2_PAR_ID_DEVICE_CERTIFICATE_0xAA11                                                            0
/**
 * Parameter: ChallengeResponse, message:DeviceAuthenticationResponse
 */
#define IAP2_PAR_ID_CHALLENGE_RESPONSE_0xAA13                                                            0
/**
 * Parameter: DeviceAuthenticationChallenge, message:RequestDeviceAuthenticationChallengeResponse
 */
#define IAP2_PAR_ID_DEVICE_AUTHENTICATION_CHALLENGE_0xAA12                                               0
/**
 * Parameter: DeviceName, message:DeviceInformationUpdate
 */
#define IAP2_PAR_ID_DEVICE_NAME_0x4E09                                                                   0
/**
 * Parameter: DeviceName, message:DeviceLanguageUpdate
 */
#define IAP2_PAR_ID_DEVICE_NAME_0x4E0A                                                                   0
/**
 * Parameter: DaylightSavingsOffsetMinutes, message:DeviceTimeUpdate
 */
#define IAP2_PAR_ID_DAYLIGHT_SAVINGS_OFFSET_MINUTES_0x4E0B                                               2
/**
 * Parameter: SecondsSinceReferenceDate, message:DeviceTimeUpdate
 */
#define IAP2_PAR_ID_SECONDS_SINCE_REFERENCE_DATE_0x4E0B                                                  0
/**
 * Parameter: TimeZoneOffsetMinutes, message:DeviceTimeUpdate
 */
#define IAP2_PAR_ID_TIME_ZONE_OFFSET_MINUTES_0x4E0B                                                      1
/**
 * Parameter: BluetoothTransportIdentifier, message:DeviceTransportIdentifierNotification
 */
#define IAP2_PAR_ID_BLUETOOTH_TRANSPORT_IDENTIFIER_0x4E0E                                                0
/**
 * Parameter: USBTransportIdentifier, message:DeviceTransportIdentifierNotification
 */
#define IAP2_PAR_ID_USB_TRANSPORT_IDENTIFIER_0x4E0E                                                      1
/**
 * Parameter: UUID, message:DeviceUUIDUpdate
 */
#define IAP2_PAR_ID_UUID_0x4E0C                                                                          0
/**
 * Parameter: Status, message:WirelessCarPlayUpdate
 */
#define IAP2_PAR_ID_STATUS_0x4E0D                                                                        0
/**
 * Parameter: ExternalAccesoryProtocolIdentifier, message:StartExternalAccessoryProtocolSession
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESORY_PROTOCOL_IDENTIFIER_0xEA00                                         0
/**
 * Parameter: ExternalAccessoryProtocolSessionIdentifier, message:StartExternalAccessoryProtocolSession
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_IDENTIFIER_0xEA00                                1
/**
 * Parameter: ExternalAccessoryProtocolSessionIdentifier, message:StatusExternalAccessoryProtocolSession
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_IDENTIFIER_0xEA03                                0
/**
 * Parameter: ExternalAccessoryProtocolSessionStatus, message:StatusExternalAccessoryProtocolSession
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_STATUS_0xEA03                                    1
/**
 * Parameter: ExternalAccessoryProtocolSessionIdentifier, message:StopExternalAccessoryProtocolSession
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_IDENTIFIER_0xEA01                                0
/**
 * Parameter: HIDComponentIdentifier, message:AccessoryHIDReport
 */
#define IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_0x6802                                                      0
/**
 * Parameter: HIDReport, message:AccessoryHIDReport
 */
#define IAP2_PAR_ID_HID_REPORT_0x6802                                                                    1
/**
 * Parameter: HIDComponentIdentifier, message:DeviceHIDReport
 */
#define IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_0x6801                                                      0
/**
 * Parameter: HIDReport, message:DeviceHIDReport
 */
#define IAP2_PAR_ID_HID_REPORT_0x6801                                                                    1
/**
 * Parameter: HIDComponentIdentifier, message:StartHID
 */
#define IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_0x6800                                                      0
/**
 * Parameter: HIDReportDescriptor, message:StartHID
 */
#define IAP2_PAR_ID_HID_REPORT_DESCRIPTOR_0x6800                                                         4
/**
 * Parameter: LocalizedKeyboardCountryCode, message:StartHID
 */
#define IAP2_PAR_ID_LOCALIZED_KEYBOARD_COUNTRY_CODE_0x6800                                               3
/**
 * Parameter: ProductIdentifier, message:StartHID
 */
#define IAP2_PAR_ID_PRODUCT_IDENTIFIER_0x6800                                                            2
/**
 * Parameter: VendorIdentifier, message:StartHID
 */
#define IAP2_PAR_ID_VENDOR_IDENTIFIER_0x6800                                                             1
/**
 * Parameter: HIDComponentIdentifier, message:StopHID
 */
#define IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_0x6803                                                      0
/**
 * Parameter: GPRMCDataStatusValueA, message:GPRMCDataStatusValuesNotification
 */
#define IAP2_PAR_ID_GPRMC_DATA_STATUS_VALUE_A_0xFFF0                                                     0
/**
 * Parameter: GPRMCDataStatusValueV, message:GPRMCDataStatusValuesNotification
 */
#define IAP2_PAR_ID_GPRMC_DATA_STATUS_VALUE_V_0xFFF0                                                     1
/**
 * Parameter: GPRMCDataStatusValueX, message:GPRMCDataStatusValuesNotification
 */
#define IAP2_PAR_ID_GPRMC_DATA_STATUS_VALUE_X_0xFFF0                                                     2
/**
 * Parameter: NMEASentence, message:LocationInformation
 */
#define IAP2_PAR_ID_NMEA_SENTENCE_0xFFFB                                                                 0
/**
 * Parameter: GlobalPositioningSystemFixData, message:StartLocationInformation
 */
#define IAP2_PAR_ID_GLOBAL_POSITIONING_SYSTEM_FIX_DATA_0xFFFA                                            1
/**
 * Parameter: GPSSatellitesInView, message:StartLocationInformation
 */
#define IAP2_PAR_ID_GPS_SATELLITES_IN_VIEW_0xFFFA                                                        3
/**
 * Parameter: RecommendedMinimumSpecificGPSTransitData, message:StartLocationInformation
 */
#define IAP2_PAR_ID_RECOMMENDED_MINIMUM_SPECIFIC_GPS_TRANSIT_DATA_0xFFFA                                 2
/**
 * Parameter: VehicleAccelerometerData, message:StartLocationInformation
 */
#define IAP2_PAR_ID_VEHICLE_ACCELEROMETER_DATA_0xFFFA                                                    6
/**
 * Parameter: VehicleGyroData, message:StartLocationInformation
 */
#define IAP2_PAR_ID_VEHICLE_GYRO_DATA_0xFFFA                                                             5
/**
 * Parameter: VehicleHeadingData, message:StartLocationInformation
 */
#define IAP2_PAR_ID_VEHICLE_HEADING_DATA_0xFFFA                                                          7
/**
 * Parameter: VehicleSpeedData, message:StartLocationInformation
 */
#define IAP2_PAR_ID_VEHICLE_SPEED_DATA_0xFFFA                                                            4
/**
 * Parameter: MediaLibraryInformationSubParameter, message:MediaLibraryInformation
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_INFORMATION_SUB_PARAMETER_0x4C01                                       0
/**
 * Parameter: MediaItem, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_MEDIA_ITEM_0x4C04                                                                    2
/**
 * Parameter: MediaItemDeletePersistentIdentifier, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_MEDIA_ITEM_DELETE_PERSISTENT_IDENTIFIER_0x4C04                                       4
/**
 * Parameter: MediaLibraryIsHidingRemoteItems, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_IS_HIDING_REMOTE_ITEMS_0x4C04                                          8
/**
 * Parameter: MediaLibraryReset, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_RESET_0x4C04                                                           6
/**
 * Parameter: MediaLibraryRevision, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_REVISION_0x4C04                                                        1
/**
 * Parameter: MediaLibraryUniqueIdentifier, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C04                                               0
/**
 * Parameter: MediaLibraryUpdateProgress, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_UPDATE_PROGRESS_0x4C04                                                 7
/**
 * Parameter: MediaPlayList, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_0x4C04                                                               3
/**
 * Parameter: MediaPlaylistDeletePersistentIdentifier, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_DELETE_PERSISTENT_IDENTIFIER_0x4C04                                   5
/**
 * Parameter: PlayAllSongsCapable, message:MediaLibraryUpdate
 */
#define IAP2_PAR_ID_PLAY_ALL_SONGS_CAPABLE_0x4C04                                                        9
/**
 * Parameter: CollectionPersistentIdentifier, message:PlayMediaLibraryCollection
 */
#define IAP2_PAR_ID_COLLECTION_PERSISTENT_IDENTIFIER_0x4C08                                              0
/**
 * Parameter: CollectionStartingIndex, message:PlayMediaLibraryCollection
 */
#define IAP2_PAR_ID_COLLECTION_STARTING_INDEX_0x4C08                                                     2
/**
 * Parameter: CollectionType, message:PlayMediaLibraryCollection
 */
#define IAP2_PAR_ID_COLLECTION_TYPE_0x4C08                                                               1
/**
 * Parameter: MediaLibraryUniqueIdentifier, message:PlayMediaLibraryCollection
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C08                                               3
/**
 * Parameter: StartingMediaItemPersistentIdentifier, message:PlayMediaLibraryCollection
 */
#define IAP2_PAR_ID_STARTING_MEDIA_ITEM_PERSISTENT_IDENTIFIER_0x4C08                                     4
/**
 * Parameter: MediaLibraryUniqueIdentifier, message:PlayMediaLibraryCurrentSelection
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C06                                               0
/**
 * Parameter: ItemsPersistentIdentifiers, message:PlayMediaLibraryItems
 */
#define IAP2_PAR_ID_ITEMS_PERSISTENT_IDENTIFIERS_0x4C07                                                  0
/**
 * Parameter: ItemsStartingIndex, message:PlayMediaLibraryItems
 */
#define IAP2_PAR_ID_ITEMS_STARTING_INDEX_0x4C07                                                          1
/**
 * Parameter: MediaLibraryUniqueIdentifier, message:PlayMediaLibraryItems
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C07                                               2
/**
 * Parameter: AllSongs, message:PlayMediaLibrarySpecial
 */
#define IAP2_PAR_ID_ALL_SONGS_0x4C09                                                                     1
/**
 * Parameter: MediaLibraryUniqueIdentifier, message:PlayMediaLibrarySpecial
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C09                                               0
/**
 * Parameter: StartingMediaItemPersistentIdentifier, message:PlayMediaLibrarySpecial
 */
#define IAP2_PAR_ID_STARTING_MEDIA_ITEM_PERSISTENT_IDENTIFIER_0x4C09                                     2
/**
 * Parameter: LastKnownMediaLibraryRevision, message:StartMediaLibraryUpdates
 */
#define IAP2_PAR_ID_LAST_KNOWN_MEDIA_LIBRARY_REVISION_0x4C03                                             1
/**
 * Parameter: MediaItemProperties, message:StartMediaLibraryUpdates
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTIES_0x4C03                                                         2
/**
 * Parameter: MediaLibraryIsHidingRemoteItems, message:StartMediaLibraryUpdates
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_IS_HIDING_REMOTE_ITEMS_0x4C03                                          5
/**
 * Parameter: MediaLibraryUniqueIdentifier, message:StartMediaLibraryUpdates
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C03                                               0 
/**
 * Parameter: MediaLibraryUpdateProgress, message:StartMediaLibraryUpdates
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_UPDATE_PROGRESS_0x4C03                                                 4
/**
 * Parameter: MediaPlaylistProperties, message:StartMediaLibraryUpdates
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_PROPERTIES_0x4C03                                                     3
/**
 * Parameter: PlayAllSongsCapable, message:StartMediaLibraryUpdates
 */
#define IAP2_PAR_ID_PLAY_ALL_SONGS_CAPABLE_0x4C03                                                        6
/**
 * Parameter: MediaPlaylistContentTransferInfoRequest, message:StartMediaLibraryUpdates
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_CONTENT_TRANSFER_INFO_REQUEST_0x4C03                                  7
/**
 * Parameter: MediaLibraryUniqueIdentifier, message:StopMediaLibraryUpdates
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C05                                               0
/**
 * Parameter: MediaItemAttributes, message:NowPlayingUpdate
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ATTRIBUTES_0x5001                                                         0
/**
 * Parameter: PlaybackAttributes, message:NowPlayingUpdate
 */
#define IAP2_PAR_ID_PLAYBACK_ATTRIBUTES_0x5001                                                           1
/**
 * Parameter: ElapsedTime, message:SetNowPlayingInformation
 */
#define IAP2_PAR_ID_ELAPSED_TIME_0x5003                                                                  0
/**
 * Parameter: PlaybackQueueIndex, message:SetNowPlayingInformation
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_INDEX_0x5003                                                          1
/**
 * Parameter: PlaybackQueueListContentTransferStartIndex, message:SetNowPlayingInformation
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_CONTENT_TRANSFER_START_INDEX_0x5003                              2
/**
 * Parameter: MediaItemAttributes, message:StartNowPlayingUpdates
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ATTRIBUTES_0x5000                                                         0
/**
 * Parameter: PlaybackAttributes, message:StartNowPlayingUpdates
 */
#define IAP2_PAR_ID_PLAYBACK_ATTRIBUTES_0x5000                                                           1
/**
 * Parameter: PlaybackQueueListContentTransferInfoRequest, message:StartNowPlayingUpdates
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_CONTENT_TRANSFER_INFO_REQUEST_0x5000                             2
/**
 * Parameter: AvailableCurrentForDevice, message:PowerSourceUpdate
 */
#define IAP2_PAR_ID_AVAILABLE_CURRENT_FOR_DEVICE_0xAE03                                                  0
/**
 * Parameter: DeviceBatteryShouldChargeIfPowerIsPresent, message:PowerSourceUpdate
 */
#define IAP2_PAR_ID_DEVICE_BATTERY_SHOULD_CHARGE_IF_POWER_IS_PRESENT_0xAE03                              1
/**
 * Parameter: AccessoryPowerMode, message:PowerUpdate
 */
#define IAP2_PAR_ID_ACCESSORY_POWER_MODE_0xAE01                                                          2
/**
 * Parameter: BatteryChargeLevel, message:PowerUpdate
 */
#define IAP2_PAR_ID_BATTERY_CHARGE_LEVEL_0xAE01                                                          6
/**
 * Parameter: BatteryChargingState, message:PowerUpdate
 */
#define IAP2_PAR_ID_BATTERY_CHARGING_STATE_0xAE01                                                        5
/**
 * Parameter: DeviceBatteryWillChargeIfPowerIsPresent, message:PowerUpdate
 */
#define IAP2_PAR_ID_DEVICE_BATTERY_WILL_CHARGE_IF_POWER_IS_PRESENT_0xAE01                                1
/**
 * Parameter: IsExternalChargerConnected, message:PowerUpdate
 */
#define IAP2_PAR_ID_IS_EXTERNAL_CHARGER_CONNECTED_0xAE01                                                 4
/**
 * Parameter: MaximumCurrentDrawnFromAccessory, message:PowerUpdate
 */
#define IAP2_PAR_ID_MAXIMUM_CURRENT_DRAWN_FROM_ACCESSORY_0xAE01                                          0
/**
 * Parameter: AccessoryPowerMode, message:StartPowerUpdates
 */
#define IAP2_PAR_ID_ACCESSORY_POWER_MODE_0xAE00                                                          2
/**
 * Parameter: BatteryChargeLevel, message:StartPowerUpdates
 */
#define IAP2_PAR_ID_BATTERY_CHARGE_LEVEL_0xAE00                                                          6
/**
 * Parameter: BatteryChargingState, message:StartPowerUpdates
 */
#define IAP2_PAR_ID_BATTERY_CHARGING_STATE_0xAE00                                                        5
/**
 * Parameter: DeviceBatteryWillChargeIfPowerIsPresent, message:StartPowerUpdates
 */
#define IAP2_PAR_ID_DEVICE_BATTERY_WILL_CHARGE_IF_POWER_IS_PRESENT_0xAE00                                1
/**
 * Parameter: IsExternalChargerConnected, message:StartPowerUpdates
 */
#define IAP2_PAR_ID_IS_EXTERNAL_CHARGER_CONNECTED_0xAE00                                                 4
/**
 * Parameter: MaximumcurrentDrawnFromAccessory, message:StartPowerUpdates
 */
#define IAP2_PAR_ID_MAXIMUMCURRENT_DRAWN_FROM_ACCESSORY_0xAE00                                           0
/**
 * Parameter: CallStatevCardFileTransferIdentifier, message:StartTelephonyCallStateInformation
 */
#define IAP2_PAR_ID_CALL_STATEV_CARD_FILE_TRANSFER_IDENTIFIER_0x4154                                     5
/**
 * Parameter: TelephonySignalStrength, message:StartTelephonyUpdates
 */
#define IAP2_PAR_ID_TELEPHONY_SIGNAL_STRENGTH_0x4157                                                     0
/**
 * Parameter: TelephonyRegistrationStatus, message:StartTelephonyUpdates
 */
#define IAP2_PAR_ID_TELEPHONY_REGISTRATION_STATUS_0x4157                                                 1
/**
 * Parameter: TelephonyAirplaneModeStatus, message:StartTelephonyUpdates
 */
#define IAP2_PAR_ID_TELEPHONY_AIRPLANE_MODE_STATUS_0x4157                                                2
/**
 * Parameter: TelephonyTTYStatus, message:StartTelephonyUpdates
 */
#define IAP2_PAR_ID_TELEPHONY_TTY_STATUS_0x4157                                                          3
/**
 * Parameter: TelephonyMobileOperator, message:StartTelephonyUpdates
 */
#define IAP2_PAR_ID_TELEPHONY_MOBILE_OPERATOR_0x4157                                                     4
/**
 * Parameter: CallStatePhoneNumber, message:TelephonyCallStateInformation
 */
#define IAP2_PAR_ID_CALL_STATE_PHONE_NUMBER_0x4155                                                       0
/**
 * Parameter: CallStateCallerName, message:TelephonyCallStateInformation
 */
#define IAP2_PAR_ID_CALL_STATE_CALLER_NAME_0x4155                                                        1
/**
 * Parameter: CallStateStatus, message:TelephonyCallStateInformation
 */
#define IAP2_PAR_ID_CALL_STATE_STATUS_0x4155                                                             2
/**
 * Parameter: CallStateDirection, message:TelephonyCallStateInformation
 */
#define IAP2_PAR_ID_CALL_STATE_DIRECTION_0x4155                                                          3
/**
 * Parameter: UniqueCallID, message:TelephonyCallStateInformation
 */
#define IAP2_PAR_ID_UNIQUE_CALL_ID_0x4155                                                                4
/**
 * Parameter: CallStatevCardFileTransferIdentifier, message:TelephonyCallStateInformation
 */
#define IAP2_PAR_ID_CALL_STATEV_CARD_FILE_TRANSFER_IDENTIFIER_0x4155                                     5
/**
 * Parameter: TelephonySignalStrength, message:TelephonyUpdate
 */
#define IAP2_PAR_ID_TELEPHONY_SIGNAL_STRENGTH_0x4158                                                     0
/**
 * Parameter: TelephonyRegistrationStatus, message:TelephonyUpdate
 */
#define IAP2_PAR_ID_TELEPHONY_REGISTRATION_STATUS_0x4158                                                 1
/**
 * Parameter: TelephonyAirplaneModeStatus, message:TelephonyUpdate
 */
#define IAP2_PAR_ID_TELEPHONY_AIRPLANE_MODE_STATUS_0x4158                                                2
/**
 * Parameter: TelephonyTTYStatus, message:TelephonyUpdate
 */
#define IAP2_PAR_ID_TELEPHONY_TTY_STATUS_0x4158                                                          3
/**
 * Parameter: TelephonyMobileOperator, message:TelephonyUpdate
 */
#define IAP2_PAR_ID_TELEPHONY_MOBILE_OPERATOR_0x4158                                                     4
/**
 * Parameter: SampleRate, message:USBDeviceModeAudioInformation
 */
#define IAP2_PAR_ID_SAMPLE_RATE_0xDA01                                                                   0
/**
 * Parameter: NightMode, message:StartVehicleStatusUpdates
 * The Parameter NightMode is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_NIGHT_MODE_0xA100                                                                    2
/**
 * Parameter: Range, message:StartVehicleStatusUpdates
 */
#define IAP2_PAR_ID_RANGE_0xA100                                                                         3
/**
 * Parameter: InsideTemperature, message:StartVehicleStatusUpdates
 * The Parameter InsideTemperature is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_INSIDE_TEMPERATURE_0xA100                                                            5
/**
 * Parameter: OutsideTemperature, message:StartVehicleStatusUpdates
 */
#define IAP2_PAR_ID_OUTSIDE_TEMPERATURE_0xA100                                                           4
/**
 * Parameter: RangeWarning, message:StartVehicleStatusUpdates
 */
#define IAP2_PAR_ID_RANGE_WARNING_0xA100                                                                 6
/**
 * Parameter: NightMode, message:VehicleStatusUpdate
 * The Parameter NightMode is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_NIGHT_MODE_0xA101                                                                    2
/**
 * Parameter: Range, message:VehicleStatusUpdate
 */
#define IAP2_PAR_ID_RANGE_0xA101                                                                         3
/**
 * Parameter: OutsideTemperature, message:VehicleStatusUpdate
 */
#define IAP2_PAR_ID_OUTSIDE_TEMPERATURE_0xA101                                                           4
/**
 * Parameter: InsideTemperature, message:VehicleStatusUpdate
 * The Parameter InsideTemperature is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_INSIDE_TEMPERATURE_0xA101                                                            5
/**
 * Parameter: RangeWarning, message:VehicleStatusUpdate
 */
#define IAP2_PAR_ID_RANGE_WARNING_0xA101                                                                 6
/**
 * Parameter: VoiceOverSpeakingRate, message:RequestVoiceOverConfiguration
 */
#define IAP2_PAR_ID_VOICE_OVER_SPEAKING_RATE_0x560E                                                      1
/**
 * Parameter: VoiceOverSpeakingVolume, message:RequestVoiceOverConfiguration
 */
#define IAP2_PAR_ID_VOICE_OVER_SPEAKING_VOLUME_0x560E                                                    0
/**
 * Parameter: CursorDirection, message:RequestVoiceOverMoveCursor
 */
#define IAP2_PAR_ID_CURSOR_DIRECTION_0x5601                                                              0
/**
 * Parameter: ScrollDirection, message:RequestVoiceOverScrollPage
 */
#define IAP2_PAR_ID_SCROLL_DIRECTION_0x5603                                                              0
/**
 * Parameter: VoiceOverTextToSpeak, message:RequestVoiceOverSpeakText
 */
#define IAP2_PAR_ID_VOICE_OVER_TEXT_TO_SPEAK_0x5606                                                      0
/**
 * Parameter: VoiceOverHint, message:StartVoiceOverCursorUpdates
 */
#define IAP2_PAR_ID_VOICE_OVER_HINT_0x560F                                                               2
/**
 * Parameter: VoiceOverLabel, message:StartVoiceOverCursorUpdates
 */
#define IAP2_PAR_ID_VOICE_OVER_LABEL_0x560F                                                              0
/**
 * Parameter: VoiceOverTraits, message:StartVoiceOverCursorUpdates
 */
#define IAP2_PAR_ID_VOICE_OVER_TRAITS_0x560F                                                             3
/**
 * Parameter: VoiceOverValue, message:StartVoiceOverCursorUpdates
 */
#define IAP2_PAR_ID_VOICE_OVER_VALUE_0x560F                                                              1
/**
 * Parameter: VoiceOverEnabled, message:StartVoiceOverUpdates
 */
#define IAP2_PAR_ID_VOICE_OVER_ENABLED_0x560B                                                            2
/**
 * Parameter: VoiceOverSpeakingRate, message:StartVoiceOverUpdates
 */
#define IAP2_PAR_ID_VOICE_OVER_SPEAKING_RATE_0x560B                                                      1
/**
 * Parameter: VoiceOverSpeakingVolume, message:StartVoiceOverUpdates
 */
#define IAP2_PAR_ID_VOICE_OVER_SPEAKING_VOLUME_0x560B                                                    0
/**
 * Parameter: VoiceOverHint, message:VoiceOverCursorUpdate
 */
#define IAP2_PAR_ID_VOICE_OVER_HINT_0x5610                                                               2
/**
 * Parameter: VoiceOverLabel, message:VoiceOverCursorUpdate
 */
#define IAP2_PAR_ID_VOICE_OVER_LABEL_0x5610                                                              0
/**
 * Parameter: VoiceOverTraits, message:VoiceOverCursorUpdate
 */
#define IAP2_PAR_ID_VOICE_OVER_TRAITS_0x5610                                                             3
/**
 * Parameter: VoiceOverValue, message:VoiceOverCursorUpdate
 */
#define IAP2_PAR_ID_VOICE_OVER_VALUE_0x5610                                                              1
/**
 * Parameter: VoiceOverEnabled, message:VoiceOverUpdate
 */
#define IAP2_PAR_ID_VOICE_OVER_ENABLED_0x560C                                                            2
/**
 * Parameter: VoiceOverSpeakingRate, message:VoiceOverUpdate
 */
#define IAP2_PAR_ID_VOICE_OVER_SPEAKING_RATE_0x560C                                                      1
/**
 * Parameter: VoiceOverSpeakingVolume, message:VoiceOverUpdate
 */
#define IAP2_PAR_ID_VOICE_OVER_SPEAKING_VOLUME_0x560C                                                    0
/**
 * Parameter: Channel, message:AccessoryWiFiConfigurationInformation
 */
#define IAP2_PAR_ID_CHANNEL_0x5703                                                                       4
/**
 * Parameter: Passphrase, message:AccessoryWiFiConfigurationInformation
 */
#define IAP2_PAR_ID_PASSPHRASE_0x5703                                                                    2
/**
 * Parameter: SecurityType, message:AccessoryWiFiConfigurationInformation
 */
#define IAP2_PAR_ID_SECURITY_TYPE_0x5703                                                                 3
/**
 * Parameter: WiFiSSID, message:AccessoryWiFiConfigurationInformation
 */
#define IAP2_PAR_ID_WI_FI_SSID_0x5703                                                                    1
/**
 * Parameter: RequestStatus, message:WiFiInformation
 */
#define IAP2_PAR_ID_REQUEST_STATUS_0x5701                                                                0
/**
 * Parameter: WiFiSSID, message:WiFiInformation
 */
#define IAP2_PAR_ID_WI_FI_SSID_0x5701                                                                    2
/**
 * Parameter: WiFiPassphrase, message:WiFiInformation
 */
#define IAP2_PAR_ID_WI_FI_PASSPHRASE_0x5701                                                              3
/**
 * Parameter: BluetoothAdvancedAudioDistributionProfile, message:BluetoothComponentProfiles
 */
#define IAP2_PAR_ID_BLUETOOTH_ADVANCED_AUDIO_DISTRIBUTION_PROFILE_SPID_4                                 4
/**
 * Parameter: BluetoothAudioVideoRemotecontrolProfile, message:BluetoothComponentProfiles
 */
#define IAP2_PAR_ID_BLUETOOTH_AUDIO_VIDEO_REMOTECONTROL_PROFILE_SPID_3                                   3
/**
 * Parameter: BluetoothHandsFreeProfile, message:BluetoothComponentProfiles
 */
#define IAP2_PAR_ID_BLUETOOTH_HANDS_FREE_PROFILE_SPID_0                                                  0
/**
 * Parameter: BluetoothHumanInterfaceDeviceProfile, message:BluetoothComponentProfiles
 */
#define IAP2_PAR_ID_BLUETOOTH_HUMAN_INTERFACE_DEVICE_PROFILE_SPID_5                                      5
/**
 * Parameter: BluetoothiAP2LinkProfile, message:BluetoothComponentProfiles
 */
#define IAP2_PAR_ID_BLUETOOTHI_AP2LINK_PROFILE_SPID_7                                                    7
/**
 * Parameter: BluetoothMessageAccessProfile, message:BluetoothComponentProfiles
 */
#define IAP2_PAR_ID_BLUETOOTH_MESSAGE_ACCESS_PROFILE_SPID_9                                              9
/**
 * Parameter: BluetoothPersonalAreaNetworkAccessPointProfile, message:BluetoothComponentProfiles
 */
#define IAP2_PAR_ID_BLUETOOTH_PERSONAL_AREA_NETWORK_ACCESS_POINT_PROFILE_SPID_8                          8
/**
 * Parameter: BluetoothPersonalAreaNetworkClientProfile, message:BluetoothComponentProfiles
 */
#define IAP2_PAR_ID_BLUETOOTH_PERSONAL_AREA_NETWORK_CLIENT_PROFILE_SPID_12                               12
/**
 * Parameter: BluetoothPhoneBookAccessProfile, message:BluetoothComponentProfiles
 */
#define IAP2_PAR_ID_BLUETOOTH_PHONE_BOOK_ACCESS_PROFILE_SPID_1                                           1
/**
 * Parameter: BTComponentEnabled, message:BluetoothComponentStatus
 */
#define IAP2_PAR_ID_BT_COMPONENT_ENABLED_SPID_1                                                          1
/**
 * Parameter: BTComponentIdentifier, message:BluetoothComponentStatus
 */
#define IAP2_PAR_ID_BT_COMPONENT_IDENTIFIER_SPID_0                                                       0
/**
 * Parameter: BluetoothTransportComponentIdentifier, message:BluetoothHIDComponent
 */
#define IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_IDENTIFIER_SPID_3                                      3
/**
 * Parameter: HIDComponentFunction, message:BluetoothHIDComponent
 */
#define IAP2_PAR_ID_HID_COMPONENT_FUNCTION_SPID_2                                                        2
/**
 * Parameter: HIDComponentIdentifier, message:BluetoothHIDComponent
 */
#define IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_SPID_0                                                      0
/**
 * Parameter: HIDComponentName, message:BluetoothHIDComponent
 */
#define IAP2_PAR_ID_HID_COMPONENT_NAME_SPID_1                                                            1
/**
 * Parameter: BluetoothTransportMediaAccessControlAddress, message:BluetoothTransportComponent
 */
#define IAP2_PAR_ID_BLUETOOTH_TRANSPORT_MEDIA_ACCESS_CONTROL_ADDRESS_SPID_3                              3
/**
 * Parameter: TransportComponentIdentifier, message:BluetoothTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0                                                0
/**
 * Parameter: TransportComponentName, message:BluetoothTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1                                                      1
/**
 * Parameter: TransportSupportsiAP2Connection, message:BluetoothTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2                                             2
/**
 * Parameter: ExternalAccessoryProtocolCarPlay, message:ExternalAccessoryProtocol
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_CAR_PLAY_SPID_4                                          4
/**
 * Parameter: ExternalAccessoryProtocolIdentifier, message:ExternalAccessoryProtocol
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_IDENTIFIER_SPID_0                                        0
/**
 * Parameter: ExternalAccessoryProtocolMatchAction, message:ExternalAccessoryProtocol
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_MATCH_ACTION_SPID_2                                      2
/**
 * Parameter: ExternalAccessoryProtocolName, message:ExternalAccessoryProtocol
 */
#define IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_NAME_SPID_1                                              1
/**
 * Parameter: NativeTransportComponentIdentifier, message:ExternalAccessoryProtocol
 */
#define IAP2_PAR_ID_NATIVE_TRANSPORT_COMPONENT_IDENTIFIER_SPID_3                                         3
/**
 * Parameter: AddressBookID, message:FavoritesList
 */
#define IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4                                                               4
/**
 * Parameter: DisplayName, message:FavoritesList
 */
#define IAP2_PAR_ID_DISPLAY_NAME_SPID_2                                                                  2
/**
 * Parameter: Index, message:FavoritesList
 */
#define IAP2_PAR_ID_INDEX_SPID_0                                                                         0
/**
 * Parameter: Label, message:FavoritesList
 */
#define IAP2_PAR_ID_LABEL_SPID_3                                                                         3
/**
 * Parameter: RemoteID, message:FavoritesList
 */
#define IAP2_PAR_ID_REMOTE_ID_SPID_1                                                                     1
/**
 * Parameter: Service, message:FavoritesList
 */
#define IAP2_PAR_ID_SERVICE_SPID_5                                                                       5
/**
 * Parameter: AddressBookID, message:FavoritesListProperties
 */
#define IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4                                                               4
/**
 * Parameter: DisplayName, message:FavoritesListProperties
 */
#define IAP2_PAR_ID_DISPLAY_NAME_SPID_2                                                                  2
/**
 * Parameter: Index, message:FavoritesListProperties
 */
#define IAP2_PAR_ID_INDEX_SPID_0                                                                         0
/**
 * Parameter: Label, message:FavoritesListProperties
 */
#define IAP2_PAR_ID_LABEL_SPID_3                                                                         3
/**
 * Parameter: RemoteID, message:FavoritesListProperties
 */
#define IAP2_PAR_ID_REMOTE_ID_SPID_1                                                                     1
/**
 * Parameter: Service, message:FavoritesListProperties
 */
#define IAP2_PAR_ID_SERVICE_SPID_5                                                                       5
/**
 * Parameter: HIDComponentFunction, message:iAP2HIDComponent
 */
#define IAP2_PAR_ID_HID_COMPONENT_FUNCTION_SPID_2                                                        2
/**
 * Parameter: HIDComponentIdentifier, message:iAP2HIDComponent
 */
#define IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_SPID_0                                                      0
/**
 * Parameter: HIDComponentName, message:iAP2HIDComponent
 */
#define IAP2_PAR_ID_HID_COMPONENT_NAME_SPID_1                                                            1
/**
 * Parameter: LocationInformationComponentGlobalPositioningSystemFixData, message:LocationInformationComponent
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_GLOBAL_POSITIONING_SYSTEM_FIX_DATA_SPID_17            17
/**
 * Parameter: LocationInformationComponentGPSSatelliteInView, message:LocationInformationComponent
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_GPS_SATELLITE_IN_VIEW_SPID_19                         19
/**
 * Parameter: LocationInformationComponentIdentifier, message:LocationInformationComponent
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_IDENTIFIER_SPID_0                                     0
/**
 * Parameter: LocationInformationComponentName, message:LocationInformationComponent
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_NAME_SPID_1                                           1
/**
 * Parameter: LocationInformationComponentRecommendedMinimumSpecificGPSTransitData, message:LocationInformationComponent
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_RECOMMENDED_MINIMUM_SPECIFIC_GPS_TRANSIT_DATA_SPID_18 18
/**
 * Parameter: LocationInformationComponentVehicleAccelerometerData, message:LocationInformationComponent
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_VEHICLE_ACCELEROMETER_DATA_SPID_22                    22
/**
 * Parameter: LocationInformationComponentVehicleGyroData, message:LocationInformationComponent
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_VEHICLE_GYRO_DATA_SPID_21                             21
/**
 * Parameter: LocationInformationComponentVehicleHeadingData, message:LocationInformationComponent
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_VEHICLE_HEADING_DATA_SPID_23                          23
/**
 * Parameter: LocationInformationComponentVehicleSpeedData, message:LocationInformationComponent
 */
#define IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_VEHICLE_SPEED_DATA_SPID_20                            20
/**
 * Parameter: MediaItemAlbumArtist, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_ARTIST_SPID_14                                                      14
/**
 * Parameter: MediaItemAlbumArtistPersistentIdentifier, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_ARTIST_PERSISTENT_IDENTIFIER_SPID_13                                13
/**
 * Parameter: MediaItemAlbumDiscCount, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_COUNT_SPID_10                                                  10
/**
 * Parameter: MediaItemAlbumDiscNumber, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_NUMBER_SPID_9                                                  9
/**
 * Parameter: MediaItemAlbumPersistentIdentifier, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_PERSISTENT_IDENTIFIER_SPID_5                                        5
/**
 * Parameter: MediaItemAlbumTitle, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TITLE_SPID_6                                                        6
/**
 * Parameter: MediaItemAlbumTrackCount, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_COUNT_SPID_8                                                  8
/**
 * Parameter: MediaItemAlbumTrackNumber, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_NUMBER_SPID_7                                                 7
/**
 * Parameter: MediaItemArtist, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ARTIST_SPID_12                                                            12
/**
 * Parameter: MediaItemArtistPersistentIdentifier, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ARTIST_PERSISTENT_IDENTIFIER_SPID_11                                      11
/**
 * Parameter: MediaItemArtworkFileTransferIdentifier, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ARTWORK_FILE_TRANSFER_IDENTIFIER_SPID_26                                  26
/**
 * Parameter: MediaItemChapterCount, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_CHAPTER_COUNT_SPID_27                                                     27
/**
 * Parameter: MediaItemComposer, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_SPID_18                                                          18
/**
 * Parameter: MediaItemComposerPersistentIdentifier, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_PERSISTENT_IDENTIFIER_SPID_17                                    17
/**
 * Parameter: MediaItemGenre, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_GENRE_SPID_16                                                             16
/**
 * Parameter: MediaItemGenrePersistentIdentifier, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_GENRE_PERSISTENT_IDENTIFIER_SPID_15                                       15
/**
 * Parameter: MediaItemIsBanned, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_BANNED_SPID_24                                                         24
/**
 * Parameter: MediaItemIsBanSupported, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_BAN_SUPPORTED_SPID_22                                                  22
/**
 * Parameter: MediaItemIsLiked, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_LIKED_SPID_23                                                          23
/**
 * Parameter: MediaItemIsLikeSupported, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_LIKE_SUPPORTED_SPID_21                                                 21
/**
 * Parameter: MediaItemIsPartOfCompilation, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_PART_OF_COMPILATION_SPID_19                                            19
/**
 * Parameter: MediaItemIsResidentOnDevice, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_RESIDENT_ON_DEVICE_SPID_25                                             25
/**
 * Parameter: MediaItemMediaType, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_MEDIA_TYPE_SPID_2                                                         2
/**
 * Parameter: MediaItemPersistentIdentifier, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PERSISTENT_IDENTIFIER_SPID_0                                              0
/**
 * Parameter: MediaItemPlaybackDurationInMilliseconds, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PLAYBACK_DURATION_IN_MILLISECONDS_SPID_4                                  4
/**
 * Parameter: MediaItemRating, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_RATING_SPID_3                                                             3
/**
 * Parameter: MediaItemTitle, message:MediaItem
 */
#define IAP2_PAR_ID_MEDIA_ITEM_TITLE_SPID_1                                                              1
/**
 * Parameter: MediaItemAlbumDiscCount, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_COUNT_SPID_10                                                  10
/**
 * Parameter: MediaItemAlbumDiscNumber, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_NUMBER_SPID_9                                                  9
/**
 * Parameter: MediaItemAlbumTitle, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TITLE_SPID_6                                                        6
/**
 * Parameter: MediaItemAlbumTrackCount, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_COUNT_SPID_8                                                  8
/**
 * Parameter: MediaItemAlbumTrackNumber, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_NUMBER_SPID_7                                                 7
/**
 * Parameter: MediaItemArtist, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ARTIST_SPID_12                                                            12
/**
 * Parameter: MediaItemArtworkFileTransferIdentifier, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ARTWORK_FILE_TRANSFER_IDENTIFIER_SPID_26                                  26
/**
 * Parameter: MediaItemChapterCount, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_CHAPTER_COUNT_SPID_27                                                     27
/**
 * Parameter: MediaItemComposer, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_SPID_18                                                          18
/**
 * Parameter: MediaItemGenre, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_GENRE_SPID_16                                                             16
/**
 * Parameter: MediaItemIsBanned, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_BANNED_SPID_24                                                         24
/**
 * Parameter: MediaItemIsBanSupported, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_BAN_SUPPORTED_SPID_22                                                  22
/**
 * Parameter: MediaItemIsLiked, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_LIKED_SPID_23                                                          23
/**
 * Parameter: MediaItemIsLikeSupported, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_IS_LIKE_SUPPORTED_SPID_21                                                 21
/**
 * Parameter: MediaItemPersistentIdentifier, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PERSISTENT_IDENTIFIER_SPID_0                                              0
/**
 * Parameter: MediaItemPlaybackDurationInMilliseconds, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PLAYBACK_DURATION_IN_MILLISECONDS_SPID_4                                  4
/**
 * Parameter: MediaItemTitle, message:MediaItemAttributes
 */
#define IAP2_PAR_ID_MEDIA_ITEM_TITLE_SPID_1                                                              1
/**
 * Parameter: MediaItemPropertyAlbumArtist, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_ARTIST_SPID_14                                             14
/**
 * Parameter: MediaItemPropertyAlbumArtistPersistentIdentifier, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_ARTIST_PERSISTENT_IDENTIFIER_SPID_13                       13
/**
 * Parameter: MediaItemPropertyAlbumDiscCount, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_DISC_COUNT_SPID_10                                         10
/**
 * Parameter: MediaItemPropertyAlbumDiscNumber, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_DISC_NUMBER_SPID_9                                         9
/**
 * Parameter: MediaItemPropertyAlbumPersistentIdentifier, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_PERSISTENT_IDENTIFIER_SPID_5                               5
/**
 * Parameter: MediaItemPropertyAlbumTitle, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_TITLE_SPID_6                                               6
/**
 * Parameter: MediaItemPropertyAlbumTrackCount, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_TRACK_COUNT_SPID_8                                         8
/**
 * Parameter: MediaItemPropertyAlbumTrackNumber, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_TRACK_NUMBER_SPID_7                                        7
/**
 * Parameter: MediaItemPropertyArtist, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ARTIST_SPID_12                                                   12
/**
 * Parameter: MediaItemPropertyArtistPersistentIdentifier, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ARTIST_PERSISTENT_IDENTIFIER_SPID_11                             11
/**
 * Parameter: MediaItemPropertyChapterCount, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_CHAPTER_COUNT_SPID_27                                            27
/**
 * Parameter: MediaItemPropertyComposer, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_COMPOSER_SPID_18                                                 18
/**
 * Parameter: MediaItemPropertyComposerPersistentIdentifier, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_COMPOSER_PERSISTENT_IDENTIFIER_SPID_17                           17
/**
 * Parameter: MediaItemPropertyGenre, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_GENRE_SPID_16                                                    16
/**
 * Parameter: MediaItemPropertyGenrePersistenIdentifier, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_GENRE_PERSISTEN_IDENTIFIER_SPID_15                               15
/**
 * Parameter: MediaItemPropertyIsBanned, message:MediaItemProperties
 * The Parameter MediaItemPropertyIsBanned is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_BANNED_SPID_24                                                24
/**
 * Parameter: MediaItemPropertyIsBanSupported, message:MediaItemProperties
 * The Parameter MediaItemPropertyIsBanSupported is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_BAN_SUPPORTED_SPID_22                                         22
/**
 * Parameter: MediaItemPropertyIsLiked, message:MediaItemProperties
 * The Parameter MediaItemPropertyIsLiked is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_LIKED_SPID_23                                                 23
/**
 * Parameter: MediaItemPropertyIsLikeSupported, message:MediaItemProperties
 * The Parameter MediaItemPropertyIsLikeSupported is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_LIKE_SUPPORTED_SPID_21                                        21
/**
 * Parameter: MediaItemPropertyIsPartOfCompilation, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_PART_OF_COMPILATION_SPID_19                                   19
/**
 * Parameter: MediaItemPropertyIsResidentOndevice, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_RESIDENT_ONDEVICE_SPID_25                                     25
/**
 * Parameter: MediaItemPropertyMediaType, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_MEDIA_TYPE_SPID_2                                                2
/**
 * Parameter: MediaItemPropertyPersistentIdentifier, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_PERSISTENT_IDENTIFIER_SPID_0                                     0
/**
 * Parameter: MediaItemPropertyPlaybackDurationInMilliseconds, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_PLAYBACK_DURATION_IN_MILLISECONDS_SPID_4                         4
/**
 * Parameter: MediaItemPropertyRating, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_RATING_SPID_3                                                    3
/**
 * Parameter: MediaItemPropertyTitle, message:MediaItemProperties
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_TITLE_SPID_1                                                     1
/**
 * Parameter: MediaLibraryName, message:MediaLibraryInformationSub
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_NAME_SPID_0                                                            0
/**
 * Parameter: MediaUniqueIdentifier, message:MediaLibraryInformationSub
 */
#define IAP2_PAR_ID_MEDIA_UNIQUE_IDENTIFIER_SPID_1                                                       1
/**
 * Parameter: MediaLibraryType, message:MediaLibraryInformationSub
 */
#define IAP2_PAR_ID_MEDIA_LIBRARY_TYPE_SPID_2                                                            2
/**
 * Parameter: MediaPlaylistContainedMediaItemsFileTransferIdentifier, message:MediaPlayList
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_CONTAINED_MEDIA_ITEMS_FILE_TRANSFER_IDENTIFIER_SPID_5                 5
/**
 * Parameter: MediaPlaylistIsAppleMusicRadioStation, message:MediaPlayList
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_IS_APPLE_MUSIC_RADIO_STATION_SPID_6                                   6
/**
 * Parameter: MediaPlaylistIsFolder, message:MediaPlayList
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_IS_FOLDER_SPID_4                                                      4
/**
 * Parameter: MediaPlaylistIsGeniusMix, message:MediaPlayList
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_IS_GENIUS_MIX_SPID_3                                                  3
/**
 * Parameter: MediaPlaylistIsiTunesRadioStation, message:MediaPlayList
 * The Parameter MediaPlaylistIsiTunesRadioStation is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_ISI_TUNES_RADIO_STATION_SPID_6                                        6
/**
 * Parameter: MediaPlaylistName, message:MediaPlayList
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_NAME_SPID_1                                                           1
/**
 * Parameter: MediaPlaylistParentPersistentIdentifer, message:MediaPlayList
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_PARENT_PERSISTENT_IDENTIFER_SPID_2                                    2
/**
 * Parameter: MediaPlaylistPersistentIdentifier, message:MediaPlayList
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_PERSISTENT_IDENTIFIER_SPID_0                                          0
/**
 * Parameter: MediaPlaylistContentTransfer, message:MediaPlayList
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_CONTENT_TRANSFER_SPID_7                                               7
/**
 * Parameter: MedialtemPlD, message:MediaPlaylistContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIALTEM_PL_D_SPID_0                                                                0
/**
 * Parameter: MedialtemTitle, message:MediaPlaylistContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIALTEM_TITLE_SPID_1                                                               1
/**
 * Parameter: MediaItemAlbumTitle, message:MediaPlaylistContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TITLE_SPID_6                                                        6
/**
 * Parameter: MediaItemArtist, message:MediaPlaylistContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ARTIST_SPID_12                                                            12
/**
 * Parameter: MedialtemAlbumArtist, message:MediaPlaylistContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIALTEM_ALBUM_ARTIST_SPID_14                                                       14
/**
 * Parameter: MediaItemGenre, message:MediaPlaylistContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_GENRE_SPID_16                                                             16
/**
 * Parameter: MediaItemComposer, message:MediaPlaylistContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_SPID_18                                                          18
/**
 * Parameter: MediaPlayListContainedMediaItems, message:MediaPlaylistProperties
 * The Parameter MediaPlayListContainedMediaItems is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_CONTAINED_MEDIA_ITEMS_SPID_5                                         5
/**
 * Parameter: MediaPlayListContainedMediaItemsFileTransferIdentifier, message:MediaPlaylistProperties
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_CONTAINED_MEDIA_ITEMS_FILE_TRANSFER_IDENTIFIER_SPID_5                5
/**
 * Parameter: MediaPlayListPropertyIsAppleMusicRadioStation, message:MediaPlaylistProperties
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_IS_APPLE_MUSIC_RADIO_STATION_SPID_6                         6
/**
 * Parameter: MediaPlayListPropertyIsFolder, message:MediaPlaylistProperties
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_IS_FOLDER_SPID_4                                            4
/**
 * Parameter: MediaPlayListPropertyIsiTunesRadioStation, message:MediaPlaylistProperties
 * The Parameter MediaPlayListPropertyIsiTunesRadioStation is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_ISI_TUNES_RADIO_STATION_SPID_6                              6
/**
 * Parameter: MediaPlayListPropertyName, message:MediaPlaylistProperties
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_NAME_SPID_1                                                 1
/**
 * Parameter: MediaPlayListPropertyParentPersistentIdentifier, message:MediaPlaylistProperties
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_PARENT_PERSISTENT_IDENTIFIER_SPID_2                         2
/**
 * Parameter: MediaPlayListPropertyPersistentIdentifier, message:MediaPlaylistProperties
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_PERSISTENT_IDENTIFIER_SPID_0                                0
/**
 * Parameter: MediaPlayListPropertyPropertyIsGeniusMix, message:MediaPlaylistProperties
 */
#define IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_PROPERTY_IS_GENIUS_MIX_SPID_3                               3
/**
 * Parameter: MediaPlaylistContentTransfer, message:MediaPlaylistProperties
 */
#define IAP2_PAR_ID_MEDIA_PLAYLIST_CONTENT_TRANSFER_SPID_7                                               7
/**
 * Parameter: PBAppleMusicRadioAd, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_AD_SPID_9                                                       9
/**
 * Parameter: PBAppleMusicRadioStationName, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_STATION_NAME_SPID_10                                            10
/**
 * Parameter: PBiTunesRadioAd, message:PlaybackAttributes
 * The Parameter PBiTunesRadioAd is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_P_BI_TUNES_RADIO_AD_SPID_9                                                           9
/**
 * Parameter: PBiTunesRadioStationMediaPlaylistPersistentID, message:PlaybackAttributes
 * The Parameter PBiTunesRadioStationMediaPlaylistPersistentID is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_P_BI_TUNES_RADIO_STATION_MEDIA_PLAYLIST_PERSISTENT_ID_SPID_11                        11
/**
 * Parameter: PBiTunesRadioStationName, message:PlaybackAttributes
 * The Parameter PBiTunesRadioStationName is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_P_BI_TUNES_RADIO_STATION_NAME_SPID_10                                                10
/**
 * Parameter: PBMediaLibraryUniqueIdentifier, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PB_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_SPID_8                                            8
/**
 * Parameter: PlaybackAppBundleID, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_APP_BUNDLE_ID_SPID_16                                                       16
/**
 * Parameter: PlaybackAppName, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_APP_NAME_SPID_7                                                             7
/**
 * Parameter: PlaybackElapsedTimeInMilliseconds, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_ELAPSED_TIME_IN_MILLISECONDS_SPID_1                                         1
/**
 * Parameter: PlaybackQueueChapterIndex, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_CHAPTER_INDEX_SPID_4                                                  4
/**
 * Parameter: PlaybackQueueCount, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_COUNT_SPID_3                                                          3
/**
 * Parameter: PlaybackQueueIndex, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_INDEX_SPID_2                                                          2
/**
 * Parameter: PlaybackQueueListAvail, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_AVAIL_SPID_14                                                    14
/**
 * Parameter: PlaybackQueueListTransferID, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_TRANSFER_ID_SPID_15                                              15
/**
 * Parameter: PlaybackRepeatMode, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_REPEAT_MODE_SPID_6                                                          6
/**
 * Parameter: PlaybackShuffleMode, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_SHUFFLE_MODE_SPID_5                                                         5
/**
 * Parameter: PlaybackSpeed, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_SPEED_SPID_12                                                               12
/**
 * Parameter: PlaybackStatus, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_STATUS_SPID_0                                                               0
/**
 * Parameter: SetElapsedTimeAvailable, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_SET_ELAPSED_TIME_AVAILABLE_SPID_13                                                   13
/**
 * Parameter: PlaybackQueueListContentTransfer, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_CONTENT_TRANSFER_SPID_17                                         17
/**
 * Parameter: PBAppeMusicRadioStationMediaPlaylistPersistentID, message:PlaybackAttributes
 */
#define IAP2_PAR_ID_PB_APPE_MUSIC_RADIO_STATION_MEDIA_PLAYLIST_PERSISTENT_ID_SPID_11                     11
/**
 * Parameter: MediaItemPID, message:PlaybackQueueListContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_PID_SPID_0                                                                0
/**
 * Parameter: MediaItemTitle, message:PlaybackQueueListContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_TITLE_SPID_1                                                              1
/**
 * Parameter: MediaItemAlbumTitle, message:PlaybackQueueListContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TITLE_SPID_6                                                        6
/**
 * Parameter: MediaItemArtist, message:PlaybackQueueListContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ARTIST_SPID_12                                                            12
/**
 * Parameter: MediaItemAlbumArtist, message:PlaybackQueueListContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_ALBUM_ARTIST_SPID_14                                                      14
/**
 * Parameter: MediaItemGenre, message:PlaybackQueueListContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_GENRE_SPID_16                                                             16
/**
 * Parameter: MediaItemComposer, message:PlaybackQueueListContentTransferInfoRequest
 */
#define IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_SPID_18                                                          18
/**
 * Parameter: AddressBookID, message:RecentsList
 */
#define IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4                                                               4
/**
 * Parameter: DisplayName, message:RecentsList
 */
#define IAP2_PAR_ID_DISPLAY_NAME_SPID_2                                                                  2
/**
 * Parameter: Duration, message:RecentsList
 */
#define IAP2_PAR_ID_DURATION_SPID_8                                                                      8
/**
 * Parameter: Index, message:RecentsList
 */
#define IAP2_PAR_ID_INDEX_SPID_0                                                                         0
/**
 * Parameter: Label, message:RecentsList
 */
#define IAP2_PAR_ID_LABEL_SPID_3                                                                         3
/**
 * Parameter: Occurrences, message:RecentsList
 */
#define IAP2_PAR_ID_OCCURRENCES_SPID_9                                                                   9
/**
 * Parameter: RemoteID, message:RecentsList
 */
#define IAP2_PAR_ID_REMOTE_ID_SPID_1                                                                     1
/**
 * Parameter: Service, message:RecentsList
 */
#define IAP2_PAR_ID_SERVICE_SPID_5                                                                       5
/**
 * Parameter: Type, message:RecentsList
 */
#define IAP2_PAR_ID_TYPE_SPID_6                                                                          6
/**
 * Parameter: UnixTimestamp, message:RecentsList
 */
#define IAP2_PAR_ID_UNIX_TIMESTAMP_SPID_7                                                                7
/**
 * Parameter: AddressBookID, message:RecentsListProperties
 */
#define IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4                                                               4
/**
 * Parameter: DisplayName, message:RecentsListProperties
 */
#define IAP2_PAR_ID_DISPLAY_NAME_SPID_2                                                                  2
/**
 * Parameter: Duration, message:RecentsListProperties
 */
#define IAP2_PAR_ID_DURATION_SPID_8                                                                      8
/**
 * Parameter: Index, message:RecentsListProperties
 */
#define IAP2_PAR_ID_INDEX_SPID_0                                                                         0
/**
 * Parameter: Label, message:RecentsListProperties
 */
#define IAP2_PAR_ID_LABEL_SPID_3                                                                         3
/**
 * Parameter: Occurrences, message:RecentsListProperties
 */
#define IAP2_PAR_ID_OCCURRENCES_SPID_9                                                                   9
/**
 * Parameter: RemoteID, message:RecentsListProperties
 */
#define IAP2_PAR_ID_REMOTE_ID_SPID_1                                                                     1
/**
 * Parameter: Service, message:RecentsListProperties
 */
#define IAP2_PAR_ID_SERVICE_SPID_5                                                                       5
/**
 * Parameter: Type, message:RecentsListProperties
 */
#define IAP2_PAR_ID_TYPE_SPID_6                                                                          6
/**
 * Parameter: UnixTimestamp, message:RecentsListProperties
 */
#define IAP2_PAR_ID_UNIX_TIMESTAMP_SPID_7                                                                7
/**
 * Parameter: Identifier, message:RouteGuidanceDisplayComponent
 */
#define IAP2_PAR_ID_IDENTIFIER_SPID_0                                                                    0
/**
 * Parameter: Name, message:RouteGuidanceDisplayComponent
 */
#define IAP2_PAR_ID_NAME_SPID_1                                                                          1
/**
 * Parameter: MaxCurrentRoadNameLength, message:RouteGuidanceDisplayComponent
 */
#define IAP2_PAR_ID_MAX_CURRENT_ROAD_NAME_LENGTH_SPID_2                                                  2
/**
 * Parameter: MaxDestinationRoadNameLength, message:RouteGuidanceDisplayComponent
 */
#define IAP2_PAR_ID_MAX_DESTINATION_ROAD_NAME_LENGTH_SPID_3                                              3
/**
 * Parameter: MaxAfterManeuverRoadNameLength, message:RouteGuidanceDisplayComponent
 */
#define IAP2_PAR_ID_MAX_AFTER_MANEUVER_ROAD_NAME_LENGTH_SPID_4                                           4
/**
 * Parameter: MaxManeuverDescriptionLength, message:RouteGuidanceDisplayComponent
 */
#define IAP2_PAR_ID_MAX_MANEUVER_DESCRIPTION_LENGTH_SPID_5                                               5
/**
 * Parameter: MaxGuidanceManeuverStorageCapacity, message:RouteGuidanceDisplayComponent
 */
#define IAP2_PAR_ID_MAX_GUIDANCE_MANEUVER_STORAGE_CAPACITY_SPID_6                                        6
/**
 * Parameter: TransportComponentIdentifier, message:SerialTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0                                                0
/**
 * Parameter: TransportComponentName, message:SerialTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1                                                      1
/**
 * Parameter: TransportSupportsiAP2Connection, message:SerialTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2                                             2
/**
 * Parameter: PBAppeMusicRadioStationMediaPlaylistPersistentID, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PB_APPE_MUSIC_RADIO_STATION_MEDIA_PLAYLIST_PERSISTENT_ID_SPID_11                     11
/**
 * Parameter: PBAppleMusicRadioAd, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_AD_SPID_9                                                       9
/**
 * Parameter: PBAppleMusicRadioStationName, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_STATION_NAME_SPID_10                                            10
/**
 * Parameter: PBiTunesRadioAd, message:StartNowPlayingPlaybackAttributes
 * The Parameter PBiTunesRadioAd is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_P_BI_TUNES_RADIO_AD_SPID_9                                                           9
/**
 * Parameter: PBiTunesStationMediaPlaylistPersistentID, message:StartNowPlayingPlaybackAttributes
 * The Parameter PBiTunesStationMediaPlaylistPersistentID is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_P_BI_TUNES_STATION_MEDIA_PLAYLIST_PERSISTENT_ID_SPID_11                              11
/**
 * Parameter: PBiTunesStationName, message:StartNowPlayingPlaybackAttributes
 * The Parameter PBiTunesStationName is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_P_BI_TUNES_STATION_NAME_SPID_10                                                      10
/**
 * Parameter: PlaybackAppBundleID, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_APP_BUNDLE_ID_SPID_16                                                       16
/**
 * Parameter: PlaybackAppName, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_APP_NAME_SPID_7                                                             7
/**
 * Parameter: PlaybackElapsedTimeInMilliseconds, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_ELAPSED_TIME_IN_MILLISECONDS_SPID_1                                         1
/**
 * Parameter: PlaybackMediaLibraryUniqueIdentifier, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_SPID_8                                      8
/**
 * Parameter: PlaybackQueueChapterIndex, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_CHAPTER_INDEX_SPID_4                                                  4
/**
 * Parameter: PlaybackQueueCount, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_COUNT_SPID_3                                                          3
/**
 * Parameter: PlaybackQueueIndex, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_INDEX_SPID_2                                                          2
/**
 * Parameter: PlaybackQueueListAvail, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_AVAIL_SPID_14                                                    14
/**
 * Parameter: PlaybackQueueListTransferID, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_TRANSFER_ID_SPID_15                                              15
/**
 * Parameter: PlaybackRepeatMode, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_REPEAT_MODE_SPID_6                                                          6
/**
 * Parameter: PlaybackShuffleMode, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_SHUFFLE_MODE_SPID_5                                                         5
/**
 * Parameter: PlaybackSpeed, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_SPEED_SPID_12                                                               12
/**
 * Parameter: PlaybackStatus, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_STATUS_SPID_0                                                               0
/**
 * Parameter: SetElapsedTimeAvailable, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_SET_ELAPSED_TIME_AVAILABLE_SPID_13                                                   13
/**
 * Parameter: PlaybackQueueListContentTransferSize, message:StartNowPlayingPlaybackAttributes
 */
#define IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_CONTENT_TRANSFER_SIZE_SPID_17                                    17
/**
 * Parameter: TransportComponentIdentifier, message:USBDeviceTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0                                                0
/**
 * Parameter: TransportComponentName, message:USBDeviceTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1                                                      1
/**
 * Parameter: TransportSupportsiAP2Connection, message:USBDeviceTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2                                             2
/**
 * Parameter: USBDeviceSupportedAudioSampleRate, message:USBDeviceTransportComponent
 */
#define IAP2_PAR_ID_USB_DEVICE_SUPPORTED_AUDIO_SAMPLE_RATE_SPID_3                                        3
/**
 * Parameter: HIDComponentFunction, message:USBHostHIDComponent
 */
#define IAP2_PAR_ID_HID_COMPONENT_FUNCTION_SPID_2                                                        2
/**
 * Parameter: HIDComponentIdentifier, message:USBHostHIDComponent
 */
#define IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_SPID_0                                                      0
/**
 * Parameter: HIDComponentName, message:USBHostHIDComponent
 */
#define IAP2_PAR_ID_HID_COMPONENT_NAME_SPID_1                                                            1
/**
 * Parameter: USBHostTransportComponentIdentifier, message:USBHostHIDComponent
 */
#define IAP2_PAR_ID_USB_HOST_TRANSPORT_COMPONENT_IDENTIFIER_SPID_3                                       3
/**
 * Parameter: USBHostTransportInterfaceNumber, message:USBHostHIDComponent
 */
#define IAP2_PAR_ID_USB_HOST_TRANSPORT_INTERFACE_NUMBER_SPID_4                                           4
/**
 * Parameter: TransportComponentIdentifier, message:USBHostTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0                                                0
/**
 * Parameter: TransportComponentName, message:USBHostTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1                                                      1
/**
 * Parameter: TransportSupportsCarPlay, message:USBHostTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_SUPPORTS_CAR_PLAY_SPID_4                                                   4
/**
 * Parameter: TransportSupportsiAP2Connection, message:USBHostTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2                                             2
/**
 * Parameter: USBHostTransportCarPlaytInterfaceNumber, message:USBHostTransportComponent
 */
#define IAP2_PAR_ID_USB_HOST_TRANSPORT_CAR_PLAYT_INTERFACE_NUMBER_SPID_3                                 3
/**
 * Parameter: DisplayName, message:VehicleInformationComponent
 */
#define IAP2_PAR_ID_DISPLAY_NAME_SPID_6                                                                  6
/**
 * Parameter: EngineType, message:VehicleInformationComponent
 */
#define IAP2_PAR_ID_ENGINE_TYPE_SPID_2                                                                   2
/**
 * Parameter: Identifier, message:VehicleInformationComponent
 */
#define IAP2_PAR_ID_IDENTIFIER_SPID_0                                                                    0
/**
 * Parameter: Name, message:VehicleInformationComponent
 */
#define IAP2_PAR_ID_NAME_SPID_1                                                                          1
/**
 * Parameter: Identifier, message:VehicleStatusComponent
 */
#define IAP2_PAR_ID_IDENTIFIER_SPID_0                                                                    0
/**
 * Parameter: InsideTemperature, message:VehicleStatusComponent
 * The Parameter InsideTemperature is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_INSIDE_TEMPERATURE_SPID_5                                                            5
/**
 * Parameter: Name, message:VehicleStatusComponent
 */
#define IAP2_PAR_ID_NAME_SPID_1                                                                          1
/**
 * Parameter: NightMode, message:VehicleStatusComponent
 * The Parameter NightMode is Deprecated, Don't use it. Kindly refer the Apple specification.
 */
#define IAP2_PAR_ID_NIGHT_MODE_SPID_2                                                                    2
/**
 * Parameter: OutsideTemperature, message:VehicleStatusComponent
 */
#define IAP2_PAR_ID_OUTSIDE_TEMPERATURE_SPID_4                                                           4
/**
 * Parameter: Range, message:VehicleStatusComponent
 */
#define IAP2_PAR_ID_RANGE_SPID_3                                                                         3
/**
 * Parameter: RangeWarning, message:VehicleStatusComponent
 */
#define IAP2_PAR_ID_RANGE_WARNING_SPID_6                                                                 6
/**
 * Parameter: TransportComponentIdentifier, message:WirelessCarPlayTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0                                                0
/**
 * Parameter: TransportComponentName, message:WirelessCarPlayTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1                                                      1
/**
 * Parameter: TransportSupportsCarPlay, message:WirelessCarPlayTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_SUPPORTS_CAR_PLAY_SPID_4                                                   4
/**
 * Parameter: TransportSupportsiAP2Connection, message:WirelessCarPlayTransportComponent
 */
#define IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2                                             2

/**
 * \brief Parameter structure of AccessoryAuthenticationSerialNumber message
 */
typedef struct
{
    /**
    * \brief Accessory Authentication Serial Number
    *
    * Accessory's X.509 certificate serial number
    */
    iAP2Blob* iAP2AuthenticationSerialNumber;
    /**
     * \brief Number of occurrences of iAP2AuthenticationSerialNumber parameter
     */
    U16 iAP2AuthenticationSerialNumber_count;

} iAP2AccessoryAuthenticationSerialNumberParameter;

/**
 * \brief Parameter structure of AuthenticationCertificate message
 */
typedef struct
{
    /**
    * \brief Accessory's X.509 certificate
    *
    * Authentication certificate retrieved from apple
    */
    iAP2Blob* iAP2AuthenticationCertificate;
    /**
     * \brief Number of occurrences of iAP2AuthenticationCertificate parameter
     */
    U16 iAP2AuthenticationCertificate_count;

} iAP2AuthenticationCertificateParameter;

/**
 * \brief Parameter structure of AuthenticationFailed message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for AuthenticationFailed message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2AuthenticationFailedParameter;

/**
 * \brief Parameter structure of AuthenticationResponse message
 */
typedef struct
{
    /**
    * \brief Computed Challenged Response
    *
    *Response challenge data computed using Authentication co-processor
    */
    iAP2Blob* iAP2AuthenticationResponse;
    /**
     * \brief Number of occurrences of iAP2AuthenticationResponse parameter
     */
    U16 iAP2AuthenticationResponse_count;

} iAP2AuthenticationResponseParameter;

/**
 * \brief Parameter structure of AuthenticationSucceeded message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for AuthenticationSucceeded message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2AuthenticationSucceededParameter;

/**
 * \brief Parameter structure of RequestAuthenticationCertificate message
 */
typedef struct
{
    /**
    * \brief Request Authentication Certificate Serial Number
    */
    U8* iAP2RequestAuthenticationCertificateSerialNumber;
    /**
     * \brief Number of occurrences of iAP2RequestAuthenticationCertificateSerialNumber parameter
     */
    U16 iAP2RequestAuthenticationCertificateSerialNumber_count;

} iAP2RequestAuthenticationCertificateParameter;

/**
 * \brief Parameter structure of RequestAuthenticationChallengeResponse message
 */
typedef struct
{
    /**
    * \brief Authentication challenge data from apple device
    */
    iAP2Blob* iAP2AuthenticationChallenge;
    /**
     * \brief Number of occurrences of iAP2AuthenticationChallenge parameter
     */
    U16 iAP2AuthenticationChallenge_count;

} iAP2RequestAuthenticationChallengeResponseParameter;

/**
 * \brief Parameter structure of CancelIdentification message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for CancelIdentification message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2CancelIdentificationParameter;

/**
 * \brief Parameter structure of IdentificationAccepted message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for IdentificationAccepted message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2IdentificationAcceptedParameter;

/**
 * \brief Parameter structure of IdentificationInformation message
 */
typedef struct
{
    /**
    * \brief Accessory Firmware Version
    *
    *It takes null-terminated UTF-8 string
    * Blank string is not allowed
    */
    U8** iAP2AccessoryFirmwareVersion;
    /**
     * \brief Number of occurrences of iAP2AccessoryFirmwareVersion parameter
     */
    U16 iAP2AccessoryFirmwareVersion_count;

    /**
    * \brief  Accessory Hardware Version
    
    * It takes null-terminated UTF-8 string
    * Blank string is not allowed
    */
    U8** iAP2AccessoryHardwareVersion;
    /**
     * \brief Number of occurrences of iAP2AccessoryHardwareVersion parameter
     */
    U16 iAP2AccessoryHardwareVersion_count;

    /**
    * \brief Accessory Manufacturer
    
    * It takes null-terminated UTF-8 string
    * Blank string is not allowed
    */
    U8** iAP2AccessoryManufacturer;
    /**
     * \brief Number of occurrences of iAP2AccessoryManufacturer parameter
     */
    U16 iAP2AccessoryManufacturer_count;

    /**
    * \brief Accessory Model ID
    
    * It takes null-terminated UTF-8 string
    * Blank string is not allowed
    */
    U8** iAP2AccessoryModelIdentifier;
    /**
     * \brief Number of occurrences of iAP2AccessoryModelIdentifier parameter
     */
    U16 iAP2AccessoryModelIdentifier_count;

    /**
    * \brief Accessory Name
    *
    * It takes null-terminated UTF-8 string
    * Blank string is not allowed
    */
    U8** iAP2AccessoryName;
    /**
     * \brief Number of occurrences of iAP2AccessoryName parameter
     */
    U16 iAP2AccessoryName_count;

    /**
    * \brief Accessory Serial number
    *
    * It takes null-terminated UTF-8 string
    * Blank string is not allowed
    */
    U8** iAP2AccessorySerialNumber;
    /**
     * \brief Number of occurrences of iAP2AccessorySerialNumber parameter
     */
    U16 iAP2AccessorySerialNumber_count;

    /**
    * \brief App Match Team ID of Preferred App
    *
    * It must be a valid iOS Developer Program Team ID
    */
    U8** iAP2AppMatchTeamID;
    /**
     * \brief Number of occurrences of iAP2AppMatchTeamID parameter
     */
    U16 iAP2AppMatchTeamID_count;

    /**
    * \brief Bluetooth HID Component of type group
    *
    * It must be declared if HID is supported over bluetooth
    */
    iAP2BluetoothHIDComponent* iAP2BluetoothHIDComponent;
    /**
     * \brief Number of occurrences of iAP2BluetoothHIDComponent parameter
     */
    U16 iAP2BluetoothHIDComponent_count;

    /**
    * \brief Bluetooth Transport component of type group. 
    *
    * It must be set if transport medium is bluetooth
    */
    iAP2BluetoothTransportComponent* iAP2BluetoothTransportComponent;
    /**
     * \brief Number of occurrences of iAP2BluetoothTransportComponent parameter
     */
    U16 iAP2BluetoothTransportComponent_count;

    /**
    * \brief Accessory's current Languange setting
    *
    * It takes null-terminated UTF-8 string
    * It must be one of the supported languages
    */
    U8** iAP2CurrentLanguage;
    /**
     * \brief Number of occurrences of iAP2CurrentLanguage parameter
     */
    U16 iAP2CurrentLanguage_count;

    /**
    * \brief Supported External Accessory Protocol of type group
    *
    * It must be declared if External Accessory Protocol feature is supported
    */
    iAP2ExternalAccessoryProtocol* iAP2ExternalAccessoryProtocol;
    /**
     * \brief Number of occurrences of iAP2ExternalAccessoryProtocol parameter
     */
    U16 iAP2ExternalAccessoryProtocol_count;

    /** 
    * \brief HID Component of type group
    *
    * It must be declared if HID feature is supported
    I*/
    iAP2iAP2HIDComponent* iAP2iAP2HIDComponent;
    /**
     * \brief Number of occurrences of iAP2iAP2HIDComponent parameter
     */
    U16 iAP2iAP2HIDComponent_count;

    /**
    * \brief Location Information Component of type group
    *
    * It must be declared if location feature is supported
    */
    iAP2LocationInformationComponent* iAP2LocationInformationComponent;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponent parameter
     */
    U16 iAP2LocationInformationComponent_count;

    /**
    * \brief Maximum Current drawn from device power pin in mA
    
    * If accessory does not supply or draw power from device, 
    * it must be set to 0.
    */
    U16* iAP2MaximumCurrentDrawnFromDevice;
    /**
     * \brief Number of occurrences of iAP2MaximumCurrentDrawnFromDevice parameter
     */
    U16 iAP2MaximumCurrentDrawnFromDevice_count;

    /**
    * \brief List of messages that accessory expects from device
    */
    iAP2Blob* iAP2MessagesRecievedfromDevice;
    /**
     * \brief Number of occurrences of iAP2MessagesRecievedfromDevice parameter
     */
    U16 iAP2MessagesRecievedfromDevice_count;

    /**
    * \brief List of messages that accessory will send
    */
    iAP2Blob* iAP2MessagesSentByAccessory;
    /**
     * \brief Number of occurrences of iAP2MessagesSentByAccessory parameter
     */
    U16 iAP2MessagesSentByAccessory_count;

    /**
    * \brief PowerProvidingCapability of type enum
    
    *All accessories must provide the values
    * If accessory does not provide power to device, it must be set to none
    */
    iAP2PowerProvidingCapability* iAP2PowerProvidingCapability;
    /**
     * \brief Number of occurrences of iAP2PowerProvidingCapability parameter
     */
    U16 iAP2PowerProvidingCapability_count;

    /**
    * \brief Serial Transport component of type group
    * 
    * It must be declared if transport mode is serial
    */
    iAP2SerialTransportComponent* iAP2SerialTransportComponent;
    /**
     * \brief Number of occurrences of iAP2SerialTransportComponent parameter
     */
    U16 iAP2SerialTransportComponent_count;

    /**
    * \brief List of Supported languages
    *
    * It takes chain of null-terminated UTF-8 strings
    * Each language separated from the next by '\0'
    */
    U8** iAP2SupportedLanguage;
    /**
     * \brief Number of occurrences of iAP2SupportedLanguage parameter
     */
    U16 iAP2SupportedLanguage_count;

    /**
    * \brief USB Device Transport Component of type group
    *
    *It must be declared if transport mode is USB device mode
    */
    iAP2USBDeviceTransportComponent* iAP2USBDeviceTransportComponent;
    /**
     * \brief Number of occurrences of iAP2USBDeviceTransportComponent parameter
     */
    U16 iAP2USBDeviceTransportComponent_count;

    /**
    * \brief USB Host HID component of type group
    *
    * It must be declared if HID is supported in USB Host mode
    */
    iAP2USBHostHIDComponent* iAP2USBHostHIDComponent;
    /**
     * \brief Number of occurrences of iAP2USBHostHIDComponent parameter
     */
    U16 iAP2USBHostHIDComponent_count;

    /**
    * \brief USBHostTransportComponent of type group
    *
    * It must be declared if Transport mode is USB host mode
    */
    iAP2USBHostTransportComponent* iAP2USBHostTransportComponent;
    /**
     * \brief Number of occurrences of iAP2USBHostTransportComponent parameter
     */
    U16 iAP2USBHostTransportComponent_count;

    /**
    * \brief Vehicle Information Component of type group
    
    * It must be declared if Vehicle status feature is supported
    */
    iAP2VehicleInformationComponent* iAP2VehicleInformationComponent;
    /**
     * \brief Number of occurrences of iAP2VehicleInformationComponent parameter
     */
    U16 iAP2VehicleInformationComponent_count;

    /**
    * \brief Route Guidance Display Component of type group
    *
    * It must be declared if Route Guidance feature is used
    */
    iAP2RouteGuidanceDisplayComponent* iAP2RouteGuidanceDisplayComponent;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceDisplayComponent parameter
     */
    U16 iAP2RouteGuidanceDisplayComponent_count;

    /**
    * \brief: Vehicle Status component of type group
    *
    *  It must be declared if Vehicle status feature is supported
    */
    iAP2VehicleStatusComponent* iAP2VehicleStatusComponent;
    /**
     * \brief Number of occurrences of iAP2VehicleStatusComponent parameter
     */
    U16 iAP2VehicleStatusComponent_count;

    /**
    * \brief Wireless CarPlay Transport Component of type group
    *
    * It must be declared if CarPlay over wireless transport is supported
    */
    iAP2WirelessCarPlayTransportComponent* iAP2WirelessCarPlayTransportComponent;
    /**
     * \brief Number of occurrences of iAP2WirelessCarPlayTransportComponent parameter
     */
    U16 iAP2WirelessCarPlayTransportComponent_count;

} iAP2IdentificationInformationParameter;

/**
 * \brief Parameter structure of IdentificationInformationUpdate message
 */
typedef struct
{
    /**
    * \brief Accessory Firmware version to be updated
    
    * It takes null-terminated UTF-8 string
    */
    U8** iAP2AccessoryFirmwareVersion;
    /**
     * \brief Number of occurrences of iAP2AccessoryFirmwareVersion parameter
     */
    U16 iAP2AccessoryFirmwareVersion_count;

    /**
    * \brief Accessory Hardware version to be updated
    * It is null-terminated UTF-8 string
    */
    U8** iAP2AccessoryHardwareVersion;
    /**
     * \brief Number of occurrences of iAP2AccessoryHardwareVersion parameter
     */
    U16 iAP2AccessoryHardwareVersion_count;

    /**
    * \brief Accessory Manufacturer to be updated
    * It is null-terminated UTF-8 string
    */
    U8** iAP2AccessoryManufacturer;
    /**
     * \brief Number of occurrences of iAP2AccessoryManufacturer parameter
     */
    U16 iAP2AccessoryManufacturer_count;

    /**
    * \brief Accessory Model Identifier to be updated
    *
    * It is null-terminated UTF-8 string
    */
    U8** iAP2AccessoryModelIdentifier;
    /**
     * \brief Number of occurrences of iAP2AccessoryModelIdentifier parameter
     */
    U16 iAP2AccessoryModelIdentifier_count;

    /**
    * \brief Accessory Name to be updated
    *
    * It is null-terminated UTF-8 string
    */
    U8** iAP2AccessoryName;
    /**
     * \brief Number of occurrences of iAP2AccessoryName parameter
     */
    U16 iAP2AccessoryName_count;

    /**
    * \brief Accessory Serial number to be updated
    *
    * It is null-terminated UTF-8 string
    */
    U8** iAP2AccessorySerialNumber;
    /**
     * \brief Number of occurrences of iAP2AccessorySerialNumber parameter
     */
    U16 iAP2AccessorySerialNumber_count;

    /**
    * \brief Current Language to be updated
    *
    * It is null-terminated UTF-8 string
    */
    U8** iAP2CurrentLanguage;
    /**
     * \brief Number of occurrences of iAP2CurrentLanguage parameter
     */
    U16 iAP2CurrentLanguage_count;

} iAP2IdentificationInformationUpdateParameter;

/**
 * \brief Parameter structure of IdentificationRejected message
 */
typedef struct
{
    /**
    * \brief TRUE if identified Firmware version is invalid
    */
    U8* iAP2AccessoryFirmwareVersion;
    /**
     * \brief Number of occurrences of iAP2AccessoryFirmwareVersion parameter
     */
    U16 iAP2AccessoryFirmwareVersion_count;

    /**
    * \brief TRUE if identified Hardware version is invalid
    */
    U8* iAP2AccessoryHardwareVersion;
    /**
     * \brief Number of occurrences of iAP2AccessoryHardwareVersion parameter
     */
    U16 iAP2AccessoryHardwareVersion_count;

    /**
    * \brief TRUE if identified  Manufacturer info is invalid
    */
    U8* iAP2AccessoryManufacturer;
    /**
     * \brief Number of occurrences of iAP2AccessoryManufacturer parameter
     */
    U16 iAP2AccessoryManufacturer_count;

    /** 
    * \brief TRUE if identified Model ID is invalid
    */
    U8* iAP2AccessoryModelIdentifier;
    /**
     * \brief Number of occurrences of iAP2AccessoryModelIdentifier parameter
     */
    U16 iAP2AccessoryModelIdentifier_count;

    /**
    * \brief TRUE if identified Accessory name is invalid
    */
    U8* iAP2AccessoryName;
    /**
     * \brief Number of occurrences of iAP2AccessoryName parameter
     */
    U16 iAP2AccessoryName_count;

    /**
    * \brief TRUE if identified Serial number is invalid
    */
    U8* iAP2AccessorySerialNumber;
    /**
     * \brief Number of occurrences of iAP2AccessorySerialNumber parameter
     */
    U16 iAP2AccessorySerialNumber_count;

    /**
    * \brief TRUE if identified App Match Team ID is invalid
    */
    U8* iAP2AppMatchTeamID;
    /**
     * \brief Number of occurrences of iAP2AppMatchTeamID parameter
     */
    U16 iAP2AppMatchTeamID_count;

    /**
    * \brief TRUE if Bluetooth HID Transport Component is not supported 
    */
    U8* iAP2BluetoothHIDComponent;
    /**
     * \brief Number of occurrences of iAP2BluetoothHIDComponent parameter
     */
    U16 iAP2BluetoothHIDComponent_count;

    /**
    * \brief TRUE if one or more identified BluetoothTransportcomponents  is not supported by device
    */
    U8* iAP2BluetoothTransportComponent;
    /**
     * \brief Number of occurrences of iAP2BluetoothTransportComponent parameter
     */
    U16 iAP2BluetoothTransportComponent_count;

    /**
    * \brief TRUE if Current Language provided in IdentificationInformation is not supported
    */
    U8* iAP2CurrentLanguage;
    /**
     * \brief Number of occurrences of iAP2CurrentLanguage parameter
     */
    U16 iAP2CurrentLanguage_count;

    /**
    * \brief TRUE if one or more identified iAP2HIDcomponents is not supported by device
    */
    U8* iAP2iAP2HIDComponent;
    /**
     * \brief Number of occurrences of iAP2iAP2HIDComponent parameter
     */
    U16 iAP2iAP2HIDComponent_count;

    /**
    * \brief TRUE if one or more identified Location Information components is not supported 
    */
    U8* iAP2LocationInformationComponent;
    /**
     * \brief Number of occurrences of iAP2LocationInformationComponent parameter
     */
    U16 iAP2LocationInformationComponent_count;

    /**
    * \brief TRUE if identified Maximum Current drawn from device is invalid or not supported
    
    */
    U8* iAP2MaximumCurrentDrawnFromDevice;
    /**
     * \brief Number of occurrences of iAP2MaximumCurrentDrawnFromDevice parameter
     */
    U16 iAP2MaximumCurrentDrawnFromDevice_count;

    /**
    * \brief TRUE if set of unsupported messages received from device
    
    */
    iAP2Blob* iAP2MessagesRecievedfromDevice;
    /**
     * \brief Number of occurrences of iAP2MessagesRecievedfromDevice parameter
     */
    U16 iAP2MessagesRecievedfromDevice_count;

    /**
    * \brief TRUE if set of unsupported messages sent by accessory
    */
    iAP2Blob* iAP2MessagesSentByAccessory;
    /**
     * \brief Number of occurrences of iAP2MessagesSentByAccessory parameter
     */
    U16 iAP2MessagesSentByAccessory_count;

    /**
    * \brief TRUE if identified power source type is not supported
    
    */
    U8* iAP2PowerProvidingCapability;
    /**
     * \brief Number of occurrences of iAP2PowerProvidingCapability parameter
     */
    U16 iAP2PowerProvidingCapability_count;

    /* The Parameter PowerSourceType is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief TRUE if identified power source type is not supported
    
    */
    U8* iAP2PowerSourceType;
    /**
     * \brief Number of occurrences of iAP2PowerSourceType parameter
     */
    U16 iAP2PowerSourceType_count;

    /* The Parameter PreferredAppBundleSeedIdentifier is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief TRUE if identified Bundle Seed identifier is invalid
    */
    U8* iAP2PreferredAppBundleSeedIdentifier;
    /**
     * \brief Number of occurrences of iAP2PreferredAppBundleSeedIdentifier parameter
     */
    U16 iAP2PreferredAppBundleSeedIdentifier_count;

    /**
    * \brief TRUE if identified serial transport component is not supported
    */
    U8* iAP2SerialTransportComponent;
    /**
     * \brief Number of occurrences of iAP2SerialTransportComponent parameter
     */
    U16 iAP2SerialTransportComponent_count;

    /**
    * \brief TRUE if one or more of External Accessory Protocol is not supported by device
    */
    U8* iAP2SupportedExternalAccessoryProtocol;
    /**
     * \brief Number of occurrences of iAP2SupportedExternalAccessoryProtocol parameter
     */
    U16 iAP2SupportedExternalAccessoryProtocol_count;

    /**
    * \brief TRUE if one or more identified language is not supported
    */
    U8* iAP2SupportedLanguage;
    /**
     * \brief Number of occurrences of iAP2SupportedLanguage parameter
     */
    U16 iAP2SupportedLanguage_count;

    /**
    * \brief TRUE if one or more identified USB device Transport Components is not supported
    */
    U8* iAP2USBDeviceTransportComponent;
    /**
     * \brief Number of occurrences of iAP2USBDeviceTransportComponent parameter
     */
    U16 iAP2USBDeviceTransportComponent_count;

    /**
    * \brief TRUE if one or more USB host HID components is not supported 
    */
    U8* iAP2USBHostHIDComponent;
    /**
     * \brief Number of occurrences of iAP2USBHostHIDComponent parameter
     */
    U16 iAP2USBHostHIDComponent_count;

    /**
    * \brief TRUE if one or more USB host transport components is not supported 
    */
    U8* iAP2USBHostTransportComponent;
    /**
     * \brief Number of occurrences of iAP2USBHostTransportComponent parameter
     */
    U16 iAP2USBHostTransportComponent_count;

    /**
    * \brief TRUE if one or more identified vehicle Information components is not supported 
    */
    U8* iAP2VehicleInformationComponent;
    /**
     * \brief Number of occurrences of iAP2VehicleInformationComponent parameter
     */
    U16 iAP2VehicleInformationComponent_count;

    /**
    * \brief TRUE if one or more identified vehicle status components is not supported 
    */
    U8* iAP2VehicleStatusComponent;
    /**
     * \brief Number of occurrences of iAP2VehicleStatusComponent parameter
     */
    U16 iAP2VehicleStatusComponent_count;

    /**
    * \brief TRUE if Wireless CarPlay Transport Component is not supported 
    */
    U8* iAP2WirelessCarPlayTransportComponent;
    /**
     * \brief Number of occurrences of iAP2WirelessCarPlayTransportComponent parameter
     */
    U16 iAP2WirelessCarPlayTransportComponent_count;

    /**
    * \brief TRUE if one or more identified RouteGuidanceDisplayComponent is not supported by device
    */
    U8* iAP2RouteGuidanceDisplayComponent;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceDisplayComponent parameter
     */
    U16 iAP2RouteGuidanceDisplayComponent_count;

} iAP2IdentificationRejectedParameter;

/**
 * \brief Parameter structure of StartIdentification message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StartIdentification message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StartIdentificationParameter;

/**
 * \brief Parameter structure of RequestAppLaunch message
 */
typedef struct
{
    /**
    * \brief Uniform type Identifier in reverse DNS format
    *
    * It takes null-terminated UTF-8 string
    */
    U8** iAP2AppBundleID;
    /**
     * \brief Number of occurrences of iAP2AppBundleID parameter
     */
    U16 iAP2AppBundleID_count;

    /**
    * \brief Launch  Alert - Launch with / without user alert
    * New param name AppLaunchMethod is not used
    * to avoid compilation errors because of same name
    * for variable and type
    *
    */
    iAP2AppLaunchMethod* iAP2LaunchAlert;
    /**
     * \brief Number of occurrences of iAP2LaunchAlert parameter
     */
    U16 iAP2LaunchAlert_count;

} iAP2RequestAppLaunchParameter;

/**
 * \brief Parameter structure of OOBBTPairingAccessoryInformation message
 */
typedef struct
{
    /*
    *brief BT Transport Component Identifier
    *
    */
    U16* iAP2BluetoothTransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2BluetoothTransportComponentIdentifier parameter
     */
    U16 iAP2BluetoothTransportComponentIdentifier_count;

    /*
    *brief Device Class
    *
    */
    U32* iAP2DeviceClass;
    /**
     * \brief Number of occurrences of iAP2DeviceClass parameter
     */
    U16 iAP2DeviceClass_count;

} iAP2OOBBTPairingAccessoryInformationParameter;

/**
 * \brief Parameter structure of OOBBTPairingCompletionInformation message
 */
typedef struct
{
    /* 
    * A result of 0 indicates success
    *
    */
    U8* iAP2ResultCode;
    /**
     * \brief Number of occurrences of iAP2ResultCode parameter
     */
    U16 iAP2ResultCode_count;

} iAP2OOBBTPairingCompletionInformationParameter;

/**
 * \brief Parameter structure of OOBBTPairingLinkKeyInformation message
 */
typedef struct
{
    /*
    *brief, Apple device's MAC address in raw bytes
    *
    */
    iAP2Blob* iAP2AppleDeviceMACAddress;
    /**
     * \brief Number of occurrences of iAP2AppleDeviceMACAddress parameter
     */
    U16 iAP2AppleDeviceMACAddress_count;

    /*
    *brief, Key for the link
    *
    */
    iAP2Blob* iAP2LinkKey;
    /**
     * \brief Number of occurrences of iAP2LinkKey parameter
     */
    U16 iAP2LinkKey_count;

} iAP2OOBBTPairingLinkKeyInformationParameter;

/**
 * \brief Parameter structure of StartOOBBTPairing message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StartOOBBTPairing message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StartOOBBTPairingParameter;

/**
 * \brief Parameter structure of StopOOBBTPairing message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopOOBBTPairing message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopOOBBTPairingParameter;

/**
 * \brief Parameter structure of RouteGuidanceManeuverUpdate message
 */
typedef struct
{
    /**
    * \brief 
    * Route Guidance Display Component Id
    */
    U16* iAP2RouteGuidanceDisplayComponentID;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceDisplayComponentID parameter
     */
    U16 iAP2RouteGuidanceDisplayComponentID_count;

    /**
    * \brief Specifies which item in the list is being updated
    */
    
    U16* iAP2Index;
    /**
     * \brief Number of occurrences of iAP2Index parameter
     */
    U16 iAP2Index_count;

    /**
    * \brief Maneuver Description
    */
    
    U8** iAP2ManeuverDescription;
    /**
     * \brief Number of occurrences of iAP2ManeuverDescription parameter
     */
    U16 iAP2ManeuverDescription_count;

    /**
    * \brief Maneuver Type
    */
    
    iAP2ManeuverType* iAP2ManeuverType;
    /**
     * \brief Number of occurrences of iAP2ManeuverType parameter
     */
    U16 iAP2ManeuverType_count;

    /**
    * \brief The name of the road the vehicle will end upon after the maneuver is completed successfully
    */
    U8** iAP2AfterManeuverRoadName;
    /**
     * \brief Number of occurrences of iAP2AfterManeuverRoadName parameter
     */
    U16 iAP2AfterManeuverRoadName_count;

    /**
    * \brief Meters between previous maneuver to this maneuver
    */
    U32* iAP2DistanceBetweenManeuver;
    /**
     * \brief Number of occurrences of iAP2DistanceBetweenManeuver parameter
     */
    U16 iAP2DistanceBetweenManeuver_count;

    /**
    * \brief Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuverDisplayUnits units
    */
    U8** iAP2DistanceBetweenManeuverDisplayStr;
    /**
     * \brief Number of occurrences of iAP2DistanceBetweenManeuverDisplayStr parameter
     */
    U16 iAP2DistanceBetweenManeuverDisplayStr_count;

    /**
    * \brief Units that must accompany DistanceBetweenManeuverDisplayStr when displayed to the user
    */
    iAP2DistanceDisplayUnits* iAP2DistanceBetweenManeuverDisplayUnits;
    /**
     * \brief Number of occurrences of iAP2DistanceBetweenManeuverDisplayUnits parameter
     */
    U16 iAP2DistanceBetweenManeuverDisplayUnits_count;

    /**
    * \brief Whether car should drive on right or left side of the road
    */
    iAP2DrivingSide* iAP2DrivingSide;
    /**
     * \brief Number of occurrences of iAP2DrivingSide parameter
     */
    U16 iAP2DrivingSide_count;

    /**
    * \brief Junction Type
    */
    iAP2JunctionType* iAP2JunctionType;
    /**
     * \brief Number of occurrences of iAP2JunctionType parameter
     */
    U16 iAP2JunctionType_count;

    /**
    * \brief 
    * Angle of a junction element (+/- 180).
    */
    S16* iAP2JunctionElementAngle;
    /**
     * \brief Number of occurrences of iAP2JunctionElementAngle parameter
     */
    U16 iAP2JunctionElementAngle_count;

    /**
    * \brief 
    * Angle of an exit junction element (+/- 180).
    */
    S16* iAP2JunctionElementExitAngle;
    /**
     * \brief Number of occurrences of iAP2JunctionElementExitAngle parameter
     */
    U16 iAP2JunctionElementExitAngle_count;

} iAP2RouteGuidanceManeuverUpdateParameter;

/**
 * \brief Parameter structure of RouteGuidanceUpdate message
 */
typedef struct
{
    /**
    * \brief 
    * Route Guidance Display ID
    */
    U16* iAP2RouteGuidanceDisplayComponentID;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceDisplayComponentID parameter
     */
    U16 iAP2RouteGuidanceDisplayComponentID_count;

    /**
    * \brief 
    * Name of current road
    */
    U8** iAP2CurrentRoadName;
    /**
     * \brief Number of occurrences of iAP2CurrentRoadName parameter
     */
    U16 iAP2CurrentRoadName_count;

    /**
    * \brief 
    * Name of the destination
    */
    U8** iAP2DestinationName;
    /**
     * \brief Number of occurrences of iAP2DestinationName parameter
     */
    U16 iAP2DestinationName_count;

    /**
    * \brief 
    * Number of seconds from reference date (Jan 1, 1970 GMT). 
    * Similar to Device Time Update.
    */
    U64* iAP2EstimatedTimeOfArrival;
    /**
     * \brief Number of occurrences of iAP2EstimatedTimeOfArrival parameter
     */
    U16 iAP2EstimatedTimeOfArrival_count;

    /**
    * \brief 
    * Number of seconds to destination
    */
    U64* iAP2TimeRemainingToDestination;
    /**
     * \brief Number of occurrences of iAP2TimeRemainingToDestination parameter
     */
    U16 iAP2TimeRemainingToDestination_count;

    /**
    * \brief 
    * Meters to end of trip
    */
    U32* iAP2DistanceRemaining;
    /**
     * \brief Number of occurrences of iAP2DistanceRemaining parameter
     */
    U16 iAP2DistanceRemaining_count;

    /**
    * \brief 
    * Display string representation of DistanceRemaining in DistanceRemainingDisplay Units. 
    */
    U8** iAP2DistanceRemainingDisplayStr;
    /**
     * \brief Number of occurrences of iAP2DistanceRemainingDisplayStr parameter
     */
    U16 iAP2DistanceRemainingDisplayStr_count;

    /**
    * \brief 
    * Meters to the next maneuver
    */
    U32* iAP2DistanceToNextManeuver;
    /**
     * \brief Number of occurrences of iAP2DistanceToNextManeuver parameter
     */
    U16 iAP2DistanceToNextManeuver_count;

    /**
    * \brief 
    * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDisplay units
    */
    U8** iAP2DistanceToNextManeuverDisplayStr;
    /**
     * \brief Number of occurrences of iAP2DistanceToNextManeuverDisplayStr parameter
     */
    U16 iAP2DistanceToNextManeuverDisplayStr_count;

    /**
    * \brief 
    * Units that must accompany DistanceToNextManeuverDisplayStr when displayed to the user
    */
    iAP2DistanceDisplayUnits* iAP2DistanceToNextManeuverDisplayUnits;
    /**
     * \brief Number of occurrences of iAP2DistanceToNextManeuverDisplayUnits parameter
     */
    U16 iAP2DistanceToNextManeuverDisplayUnits_count;

    /**
    * \brief 
    * Units that must accompany DistanceRemainingDisplayStr when displayed to the user
    */
    iAP2DistanceDisplayUnits* iAP2DistanceRemainingDisplayUnits;
    /**
     * \brief Number of occurrences of iAP2DistanceRemainingDisplayUnits parameter
     */
    U16 iAP2DistanceRemainingDisplayUnits_count;

    /**
    * \brief 
    * Indicates the current route guidance state
    * 0 No Route Set - A route is not set.
    * 1 Route Set - A route is set.
    * 2 Arrived - Arrived at the destination.
    * 3 Loading - Retrieving routing information  
    * 4 Locating - Location/position not available. 
    * 5 Rerouting - Recalculating the route.
    * 6 Proceed to Route - Vehicle needs to join the route.
    */
    iAP2RouteGuidanceState* iAP2RouteGuidanceState;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceState parameter
     */
    U16 iAP2RouteGuidanceState_count;

    /**
    * \brief 
    * Maneuver State
    * 0 Continue
    * 1 Initial
    * 2 Prepare
    * 3 Execute
    */
    iAP2ManeuverState* iAP2ManeuverState;
    /**
     * \brief Number of occurrences of iAP2ManeuverState parameter
     */
    U16 iAP2ManeuverState_count;

    /**
    * \brief 
    * lndices of next upcoming
    * maneuvers in the RouteGuidance
    * maneuver list. Multiple manuvers
    * that occur very close together
    * can be grouped into an ordered
    * list of indices with this
    * parameter. 
    */
    iAP2Blob* iAP2RouteGuidanceManeuverCurrentList;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceManeuverCurrentList parameter
     */
    U16 iAP2RouteGuidanceManeuverCurrentList_count;

    /**
    * \brief 
    * Total number of maneuvers in the RouteGuidance maneuver list
    */
    U16* iAP2RouteGuidanceManeuverCount;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceManeuverCount parameter
     */
    U16 iAP2RouteGuidanceManeuverCount_count;

    /**
    * \brief 
    * Whether route guidance is visible in the navigation app.
    */
    U8* iAP2RouteGuidanceVisiblelnApp;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceVisiblelnApp parameter
     */
    U16 iAP2RouteGuidanceVisiblelnApp_count;

} iAP2RouteGuidanceUpdateParameter;

/**
 * \brief Parameter structure of StartRouteGuidanceUpdate message
 */
typedef struct
{
    /**
    * \brief Route command display component ID
    * If none are specified, assume all such components are being started
    */
    U16* iAP2RouteGuidanceDisplayComponentID;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceDisplayComponentID parameter
     */
    U16 iAP2RouteGuidanceDisplayComponentID_count;

} iAP2StartRouteGuidanceUpdateParameter;

/**
 * \brief Parameter structure of StopRouteGuidanceUpdate message
 */
typedef struct
{
    /**
    * \brief Route command display component ID
    * If none are specified, assume all such components are to be stopped
    */
    U16* iAP2RouteGuidanceDisplayComponentID;
    /**
     * \brief Number of occurrences of iAP2RouteGuidanceDisplayComponentID parameter
     */
    U16 iAP2RouteGuidanceDisplayComponentID_count;

} iAP2StopRouteGuidanceUpdateParameter;

/**
 * \brief Parameter structure of AssistiveTouchInformation message
 */
typedef struct
{
    /**
    * \brief Assistive touch enabled or not
    */
    U8* IsEnabled;
    /**
     * \brief Number of occurrences of IsEnabled parameter
     */
    U16 IsEnabled_count;

} iAP2AssistiveTouchInformationParameter;

/**
 * \brief Parameter structure of StartAssistiveTouchInformation message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StartAssistiveTouchInformation message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StartAssistiveTouchInformationParameter;

/**
 * \brief Parameter structure of StartAssistiveTouch message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StartAssistiveTouch message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StartAssistiveTouchParameter;

/**
 * \brief Parameter structure of StopAssistiveTouchInformation message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopAssistiveTouchInformation message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopAssistiveTouchInformationParameter;

/**
 * \brief Parameter structure of StopAssistiveTouch message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopAssistiveTouch message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopAssistiveTouchParameter;

/**
 * \brief Parameter structure of BluetoothComponentInformation message
 */
typedef struct
{
    /**
    * \brief iAP2BluetoothComponentStatus of type group
    *
    * Status of every identified bluetooth component
    * Multiple iAP2BluetoothComponentStatus structs may be handed over here.
    */
    iAP2BluetoothComponentStatus* iAP2BluetoothComponentStatus;
    /**
     * \brief Number of occurrences of iAP2BluetoothComponentStatus parameter
     */
    U16 iAP2BluetoothComponentStatus_count;

} iAP2BluetoothComponentInformationParameter;

/**
 * \brief Parameter structure of BluetoothConnectionUpdate message
 */
typedef struct
{
    /**
    * \brief Bluetooth component profiles
    *
    * According to the specification the name is ConnectedBluetoothProfiles
    * Status of Bluetooth component
    */
    iAP2BluetoothComponentProfiles* iAP2BluetoothComponentProfiles;
    /**
     * \brief Number of occurrences of iAP2BluetoothComponentProfiles parameter
     */
    U16 iAP2BluetoothComponentProfiles_count;

    /**
    * \brief Identifier of Bluetooth component
    */
    U16* iAP2BluetoothTransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2BluetoothTransportComponentIdentifier parameter
     */
    U16 iAP2BluetoothTransportComponentIdentifier_count;

} iAP2BluetoothConnectionUpdateParameter;

/**
 * \brief Parameter structure of StartBluetoothConnectionUpdates message
 */
typedef struct
{
    /** 
    * \brief ID of Bluetooth Transport components
    *
    * List of Identifiers of Bluetooth transport components 
    * to receive Bluetooth Component updates from device
    */
    U16* iAP2BluetoothTransportComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2BluetoothTransportComponentIdentifier parameter
     */
    U16 iAP2BluetoothTransportComponentIdentifier_count;

} iAP2StartBluetoothConnectionUpdatesParameter;

/**
 * \brief Parameter structure of StopBluetoothConnectionUpdates message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopBluetoothConnectionUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopBluetoothConnectionUpdatesParameter;

/**
 * \brief Parameter structure of AcceptCall message
 */
typedef struct
{
    /**
    * \brief Accept Call Accept Action 
    */
    iAP2AcceptCallAcceptAction* iAP2AcceptAction;
    /**
     * \brief Number of occurrences of iAP2AcceptAction parameter
     */
    U16 iAP2AcceptAction_count;

    /**
    * \brief UUID of call to accept
    */
    U8** iAP2CallUUID;
    /**
     * \brief Number of occurrences of iAP2CallUUID parameter
     */
    U16 iAP2CallUUID_count;

} iAP2AcceptCallParameter;

/**
 * \brief Parameter structure of CallStateUpdate message
 */
typedef struct
{
    /**
    * \brief Address Book ID
    */
    U8** iAP2AddressBookID;
    /**
     * \brief Number of occurrences of iAP2AddressBookID parameter
     */
    U16 iAP2AddressBookID_count;

    /**
    * \brief UUID of call
    */
    U8** iAP2CallUUID;
    /**
     * \brief Number of occurrences of iAP2CallUUID parameter
     */
    U16 iAP2CallUUID_count;

    /**
    * \brief Conference group number
    * 
    * Will only be sent if IsConferenced = 1
    */
    U8* iAP2ConferenceGroup;
    /**
     * \brief Number of occurrences of iAP2ConferenceGroup parameter
     */
    U16 iAP2ConferenceGroup_count;

    /**
    * \brief Direction of call
    */
    iAP2CallStateUpdateDirection* iAP2Direction;
    /**
     * \brief Number of occurrences of iAP2Direction parameter
     */
    U16 iAP2Direction_count;

    /**
    * \brief Disconnect reason for the call
    */
    iAP2CallStateUpdateDisconnectReason* iAP2DisconnectReason;
    /**
     * \brief Number of occurrences of iAP2DisconnectReason parameter
     */
    U16 iAP2DisconnectReason_count;

    /**
    * \brief Caller's display name on phone
    *
    * In Contacts: John
    * Not in Contacts:(408)-090-890
    */
    U8** iAP2DisplayName;
    /**
     * \brief Number of occurrences of iAP2DisplayName parameter
     */
    U16 iAP2DisplayName_count;

    /**
    * \brief IsConferenced
    *
    * Whether this call is part of conference or not
    */
    U8* iAP2IsConferenced;
    /**
     * \brief Number of occurrences of iAP2IsConferenced parameter
     */
    U16 iAP2IsConferenced_count;

    /**
    * \brief Caller's label
    *
    * In Contacts: mobile, work, home
    * Not in Contacts: San Jose, CA
    */
    U8** iAP2Label;
    /**
     * \brief Number of occurrences of iAP2Label parameter
     */
    U16 iAP2Label_count;

    /**
    * \brief Remote phone number or email
    */
    U8** iAP2RemoteID;
    /**
     * \brief Number of occurrences of iAP2RemoteID parameter
     */
    U16 iAP2RemoteID_count;

    /**
    * \brief Call State Update Service
    */
    iAP2CallStateUpdateService* iAP2Service;
    /**
     * \brief Number of occurrences of iAP2Service parameter
     */
    U16 iAP2Service_count;

    /**
    * \brief Status of the call
    */
    iAP2CallStateUpdateStatus* iAP2Status;
    /**
     * \brief Number of occurrences of iAP2Status parameter
     */
    U16 iAP2Status_count;

    /**
    * \brief Unix timestamp in UTC
    */
    U64* iAP2StartTimestamp;
    /**
     * \brief Number of occurrences of iAP2StartTimestamp parameter
     */
    U16 iAP2StartTimestamp_count;

} iAP2CallStateUpdateParameter;

/**
 * \brief Parameter structure of CommunicationsUpdate message
 */
typedef struct
{
    /**
    * \brief TRUE if Airplane Mode is set in phone
    */
    U8* iAP2AirplaneModeStatus;
    /**
     * \brief Number of occurrences of iAP2AirplaneModeStatus parameter
     */
    U16 iAP2AirplaneModeStatus_count;

    /**
    * \brief Name of Carrier
    *
    * Will not be sent if Cellular Supported is false
    */
    U8** iAP2CarrierName;
    /**
     * \brief Number of occurrences of iAP2CarrierName parameter
     */
    U16 iAP2CarrierName_count;

    /**
    * \brief TRUE if Cellular is Supported
    */
    U8* iAP2CellularSupported;
    /**
     * \brief Number of occurrences of iAP2CellularSupported parameter
     */
    U16 iAP2CellularSupported_count;

    /**
    * \brief Count of Current Calls
    */
    U8* iAP2CurrentCallCount;
    /**
     * \brief Number of occurrences of iAP2CurrentCallCount parameter
     */
    U16 iAP2CurrentCallCount_count;

    /**
    * \brief End And Accept Available
    * 
    * TRUE if End And Accept feature is available
    */
    U8* iAP2EndAndAcceptAvailable;
    /**
     * \brief Number of occurrences of iAP2EndAndAcceptAvailable parameter
     */
    U16 iAP2EndAndAcceptAvailable_count;

    /**
    * \brief FaceTime Audio Enabled
    * 
    * TRUE if Face Time Audio is Enabled
    */
    U8* iAP2FaceTimeAudioEnabled;
    /**
     * \brief Number of occurrences of iAP2FaceTimeAudioEnabled parameter
     */
    U16 iAP2FaceTimeAudioEnabled_count;

    /**
    * \brief FaceTime Video Enabled
    * 
    * TRUE if Face Time Video is Enabled
    */
    U8* iAP2FaceTimeVideoEnabled;
    /**
     * \brief Number of occurrences of iAP2FaceTimeVideoEnabled parameter
     */
    U16 iAP2FaceTimeVideoEnabled_count;

    /**
    * \brief Hold And Accept Available
    * 
    * TRUE if Hold and Accept feature is available
    */
    U8* iAP2HoldAndAcceptAvailable;
    /**
     * \brief Number of occurrences of iAP2HoldAndAcceptAvailable parameter
     */
    U16 iAP2HoldAndAcceptAvailable_count;

    /**
    * \brief Hold Available
    * 
    * You cannot place a call on hold if this is false
    * You can un-hold a call if the status is held even 
    * if this is false
    */
    U8* iAP2HoldAvailable;
    /**
     * \brief Number of occurrences of iAP2HoldAvailable parameter
     */
    U16 iAP2HoldAvailable_count;

    /**
    * \brief Initiate Call Available
    * 
    * TRUE if allowed to initiate a call or add a call
    * if one is already active
    */
    U8* iAP2InitiateCallAvailable;
    /**
     * \brief Number of occurrences of iAP2InitiateCallAvailable parameter
     */
    U16 iAP2InitiateCallAvailable_count;

    /**
    * \brief Merge Available
    * 
    * TRUE if allowed to merge more than one active call
    */
    U8* iAP2MergeAvailable;
    /**
     * \brief Number of occurrences of iAP2MergeAvailable parameter
     */
    U16 iAP2MergeAvailable_count;

    /**
    * \brief Mute Status
    * 
    * TRUE if call is muted
    */
    U8* iAP2MuteStatus;
    /**
     * \brief Number of occurrences of iAP2MuteStatus parameter
     */
    U16 iAP2MuteStatus_count;

    /**
    * \brief New Voicemail Count
    * 
    * holds the count of new Voicemails
    */
    U8* iAP2NewVoicemailCount;
    /**
     * \brief Number of occurrences of iAP2NewVoicemailCount parameter
     */
    U16 iAP2NewVoicemailCount_count;

    /**
    * \brief Registration Status
    * 
    * Will not be sent if Cellular Supported is false
    */
    iAP2CommunicationsUpdateRegistrationStatus* iAP2RegistrationStatus;
    /**
     * \brief Number of occurrences of iAP2RegistrationStatus parameter
     */
    U16 iAP2RegistrationStatus_count;

    /**
    * \brief Signal Strength
    * 
    * Will not be sent if Cellular Supported is false
    */
    iAP2CommunicationsUpdateSignalStrength* iAP2SignalStrength;
    /**
     * \brief Number of occurrences of iAP2SignalStrength parameter
     */
    U16 iAP2SignalStrength_count;

    /**
    * \brief Swap Available
    * 
    * TRUE if swapping between active call is allowed 
    */
    U8* iAP2SwapAvailable;
    /**
     * \brief Number of occurrences of iAP2SwapAvailable parameter
     */
    U16 iAP2SwapAvailable_count;

    /**
    * \brief Telephony Enabled
    * 
    * TRUE if Telephony is Enabled
    */
    U8* iAP2TelephonyEnabled;
    /**
     * \brief Number of occurrences of iAP2TelephonyEnabled parameter
     */
    U16 iAP2TelephonyEnabled_count;

} iAP2CommunicationsUpdateParameter;

/**
 * \brief Parameter structure of EndCall message
 */
typedef struct
{
    /**
    * \brief Call UUID
    * 
    * UUID of call to end
    */
    U8** iAP2CallUUID;
    /**
     * \brief Number of occurrences of iAP2CallUUID parameter
     */
    U16 iAP2CallUUID_count;

    /**
    * \brief End Action
    * 
    * Action to end call
    */
    iAP2EndCallEndAction* iAP2EndAction;
    /**
     * \brief Number of occurrences of iAP2EndAction parameter
     */
    U16 iAP2EndAction_count;

} iAP2EndCallParameter;

/**
 * \brief Parameter structure of HoldStatusUpdate message
 */
typedef struct
{
    /**
    * \brief Call UUID
    * 
    * UUID of call to update hold status
    */
    U8** iAP2CallUUID;
    /**
     * \brief Number of occurrences of iAP2CallUUID parameter
     */
    U16 iAP2CallUUID_count;

    /**
    * \brief Hold Status Update
    * 
    * TRUE if call is on hold
    */
    U8* iAP2HoldStatusUpdate;
    /**
     * \brief Number of occurrences of iAP2HoldStatusUpdate parameter
     */
    U16 iAP2HoldStatusUpdate_count;

} iAP2HoldStatusUpdateParameter;

/**
 * \brief Parameter structure of InitiateCall message
 */
typedef struct
{
    /**
    * \brief Address Book ID
    *
    */
    U8** iAP2AddressBookID;
    /**
     * \brief Number of occurrences of iAP2AddressBookID parameter
     */
    U16 iAP2AddressBookID_count;

    /**
    * \brief Destination ID
    *
    * Required for destination call. Number to call
    * Format: 456378190
    * Format: +91782782989
    */
    U8** iAP2DestinationID;
    /**
     * \brief Number of occurrences of iAP2DestinationID parameter
     */
    U16 iAP2DestinationID_count;

    /**
    * \brief Initiate Call Service
    *
    * Required for destination call
    */
    iAP2InitiateCallService* iAP2Service;
    /**
     * \brief Number of occurrences of iAP2Service parameter
     */
    U16 iAP2Service_count;

    /**
    * \brief Initiate Call type
    *
    */
    iAP2InitiateCallType* iAP2Type;
    /**
     * \brief Number of occurrences of iAP2Type parameter
     */
    U16 iAP2Type_count;

} iAP2InitiateCallParameter;

/**
 * \brief Parameter structure of ListUpdate message
 */
typedef struct
{
    /**
    * \brief Favorites List
    */
    iAP2FavoritesList* iAP2FavoritesList;
    /**
     * \brief Number of occurrences of iAP2FavoritesList parameter
     */
    U16 iAP2FavoritesList_count;

    /**
    * \brief Favorites List Available
    *
    * TRUE if Favorites List is available
    */
    U8* iAP2FavoritesListAvailable;
    /**
     * \brief Number of occurrences of iAP2FavoritesListAvailable parameter
     */
    U16 iAP2FavoritesListAvailable_count;

    /**
    * \brief Favorites List Count
    */
    U16* iAP2FavoritesListCount;
    /**
     * \brief Number of occurrences of iAP2FavoritesListCount parameter
     */
    U16 iAP2FavoritesListCount_count;

    /**
    * \brief Recents List 
    */
    iAP2RecentsList* iAP2RecentsList;
    /**
     * \brief Number of occurrences of iAP2RecentsList parameter
     */
    U16 iAP2RecentsList_count;

    /**
    * \brief Recents List Available
    *
    * TRUE if Recents List is available
    */
    U8* iAP2RecentsListAvailable;
    /**
     * \brief Number of occurrences of iAP2RecentsListAvailable parameter
     */
    U16 iAP2RecentsListAvailable_count;

    /**
    * \brief Recents List Count
    */
    U16* iAP2RecentsListCount;
    /**
     * \brief Number of occurrences of iAP2RecentsListCount parameter
     */
    U16 iAP2RecentsListCount_count;

} iAP2ListUpdateParameter;

/**
 * \brief Parameter structure of MergeCalls message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for MergeCalls message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2MergeCallsParameter;

/**
 * \brief Parameter structure of MuteStatusUpdate message
 */
typedef struct
{
    /**
    * \brief Mute Status
    *
    * TRUE if call is in Mute state
    */
    U8* iAP2MuteStatus;
    /**
     * \brief Number of occurrences of iAP2MuteStatus parameter
     */
    U16 iAP2MuteStatus_count;

} iAP2MuteStatusUpdateParameter;

/**
 * \brief Parameter structure of SendDTMF message
 */
typedef struct
{
    /**
    * \brief Call UUID
    *
    * UUID of call to play tone
    */
    U8** iAP2CallUUID;
    /**
     * \brief Number of occurrences of iAP2CallUUID parameter
     */
    U16 iAP2CallUUID_count;

    /**
    * \brief DTMF Tone
    */
    iAP2SendDTMFTone* iAP2Tone;
    /**
     * \brief Number of occurrences of iAP2Tone parameter
     */
    U16 iAP2Tone_count;

} iAP2SendDTMFParameter;

/**
 * \brief Parameter structure of StartCallStateUpdates message
 */
typedef struct
{
    /**
    * \brief ID of Address Book
    */
    U8* iAP2AddressBookID;
    /**
     * \brief Number of occurrences of iAP2AddressBookID parameter
     */
    U16 iAP2AddressBookID_count;

    /**
    * \brief UUID of call
    */
    U8* iAP2CallUUID;
    /**
     * \brief Number of occurrences of iAP2CallUUID parameter
     */
    U16 iAP2CallUUID_count;

    /**
    * \brief Conference Group
    *
    * Will only be sent if IsConferenced is TRUE 
    */
    U8* iAP2ConferenceGroup;
    /**
     * \brief Number of occurrences of iAP2ConferenceGroup parameter
     */
    U16 iAP2ConferenceGroup_count;

    /**
    * \brief Direction of call
    */
    U8* iAP2Direction;
    /**
     * \brief Number of occurrences of iAP2Direction parameter
     */
    U16 iAP2Direction_count;

    /**
    * \brief Reason for disconnection of call
    */
    U8* iAP2DisconnectReason;
    /**
     * \brief Number of occurrences of iAP2DisconnectReason parameter
     */
    U16 iAP2DisconnectReason_count;

    /**
    * \brief Caller's display name on phone
    *
    * In Contacts: John Smith
    * Not in Contacts: (408) 996-1010
    */
    U8* iAP2DisplayName;
    /**
     * \brief Number of occurrences of iAP2DisplayName parameter
     */
    U16 iAP2DisplayName_count;

    /**
    * \brief Whether this call is part of conference or not
    */
    U8* iAP2IsConferenced;
    /**
     * \brief Number of occurrences of iAP2IsConferenced parameter
     */
    U16 iAP2IsConferenced_count;

    /**
    * \brief Caller's label
    * In Contacts: mobile,work,home
    * Not in Contacts: San Jose, CA
    */
    U8* iAP2Label;
    /**
     * \brief Number of occurrences of iAP2Label parameter
     */
    U16 iAP2Label_count;

    /**
    * \brief Remote phone number or email
    */
    U8* iAP2RemoteID;
    /**
     * \brief Number of occurrences of iAP2RemoteID parameter
     */
    U16 iAP2RemoteID_count;

    /**
    * \brief Call service type
    */
    U8* iAP2Service;
    /**
     * \brief Number of occurrences of iAP2Service parameter
     */
    U16 iAP2Service_count;

    /**
    * \brief Status of call
    */
    U8* iAP2Status;
    /**
     * \brief Number of occurrences of iAP2Status parameter
     */
    U16 iAP2Status_count;

    /**
    * \brief Timestamp Update
    */
    U8* iAP2StartTimestamp;
    /**
     * \brief Number of occurrences of iAP2StartTimestamp parameter
     */
    U16 iAP2StartTimestamp_count;

} iAP2StartCallStateUpdatesParameter;

/**
 * \brief Parameter structure of StartCommunicationsUpdates message
 */
typedef struct
{
    /**
    * \brief TRUE if Airplane Mode is set in phone
    */
    U8* iAP2AirplaneModeStatus;
    /**
     * \brief Number of occurrences of iAP2AirplaneModeStatus parameter
     */
    U16 iAP2AirplaneModeStatus_count;

    /**
    * \brief Name of carrier
    *
    * Will not be sent if Cellular Supported is false
    */
    U8* iAP2CarrierName;
    /**
     * \brief Number of occurrences of iAP2CarrierName parameter
     */
    U16 iAP2CarrierName_count;

    /**
    * \brief TRUE if Cellular is Supported
    */
    U8* iAP2CellularSupported;
    /**
     * \brief Number of occurrences of iAP2CellularSupported parameter
     */
    U16 iAP2CellularSupported_count;

    /**
    * \brief Count of Current calls
    */
    U8* iAP2CurrentCallCount;
    /**
     * \brief Number of occurrences of iAP2CurrentCallCount parameter
     */
    U16 iAP2CurrentCallCount_count;

    /**
    * \brief TRUE if End And Accept feature is available
    */
    U8* iAP2EndAndAcceptAvailable;
    /**
     * \brief Number of occurrences of iAP2EndAndAcceptAvailable parameter
     */
    U16 iAP2EndAndAcceptAvailable_count;

    /**
    * \brief TRUE if FaceTime Audio feature is available
    */
    U8* iAP2FaceTimeAudioEnabled;
    /**
     * \brief Number of occurrences of iAP2FaceTimeAudioEnabled parameter
     */
    U16 iAP2FaceTimeAudioEnabled_count;

    /**
    * \brief TRUE if FaceTime Video feature is available
    */
    
    
    U8* iAP2FaceTimeVideoEnabled;
    /**
     * \brief Number of occurrences of iAP2FaceTimeVideoEnabled parameter
     */
    U16 iAP2FaceTimeVideoEnabled_count;

    /**
    * \brief TRUE if Hold and Accept feature is available
    */
    U8* iAP2HoldAndAcceptAvailable;
    /**
     * \brief Number of occurrences of iAP2HoldAndAcceptAvailable parameter
     */
    U16 iAP2HoldAndAcceptAvailable_count;

    /**
    * \brief Hold Available
    *
    * You cannot place a call on hold if this is false
    * You can un-hold a call if the status is held even 
    * if this is false
    */
    U8* iAP2HoldAvailable;
    /**
     * \brief Number of occurrences of iAP2HoldAvailable parameter
     */
    U16 iAP2HoldAvailable_count;

    /**
    * \brief Initiate Call Available
    *
    * TRUE if allowed to initiate a call or add a call
    * if one is already active
    */
    U8* iAP2InitiateCallAvailable;
    /**
     * \brief Number of occurrences of iAP2InitiateCallAvailable parameter
     */
    U16 iAP2InitiateCallAvailable_count;

    /**
    * \brief Merge Available
    *
    * TRUE if allowed to merge more than one active call
    */
    U8* iAP2MergeAvailable;
    /**
     * \brief Number of occurrences of iAP2MergeAvailable parameter
     */
    U16 iAP2MergeAvailable_count;

    /**
    * \brief Mute Status
    *
    * TRUE if call is muted
    */
    U8* iAP2MuteStatus;
    /**
     * \brief Number of occurrences of iAP2MuteStatus parameter
     */
    U16 iAP2MuteStatus_count;

    /**
    * \brief New Voicemail count
    *
    * holds the count of new Voicemails
    * if one is already active
    */
    U8* iAP2NewVoiceMailCount;
    /**
     * \brief Number of occurrences of iAP2NewVoiceMailCount parameter
     */
    U16 iAP2NewVoiceMailCount_count;

    /**
    * \brief Registration Status
    *
    * Will not be sent if Cellular Supported is false
    */
    U8* iAP2RegistrationStatus;
    /**
     * \brief Number of occurrences of iAP2RegistrationStatus parameter
     */
    U16 iAP2RegistrationStatus_count;

    /**
    * \brief Signal Strength
    *
    * Will not be sent if Cellular Supported is false
    */
    U8* iAP2SignalStrength;
    /**
     * \brief Number of occurrences of iAP2SignalStrength parameter
     */
    U16 iAP2SignalStrength_count;

    /**
    * \brief TRUE if swapping between active call is allowed
    */
    U8* iAP2SwapAvailable;
    /**
     * \brief Number of occurrences of iAP2SwapAvailable parameter
     */
    U16 iAP2SwapAvailable_count;

    /**
    * \brief TRUE if Telephony is Enabled
    */
    U8* iAP2TelephonyEnabled;
    /**
     * \brief Number of occurrences of iAP2TelephonyEnabled parameter
     */
    U16 iAP2TelephonyEnabled_count;

} iAP2StartCommunicationsUpdatesParameter;

/**
 * \brief Parameter structure of StartListUpdates message
 */
typedef struct
{
    /**
    * \brief Favorites List Max
    *
    * Max entries to send; 0 = no limit
    */
    U16* iAP2FavoritesListMax;
    /**
     * \brief Number of occurrences of iAP2FavoritesListMax parameter
     */
    U16 iAP2FavoritesListMax_count;

    /**
    * \brief Favorites List Properties
    *
    * Sending this parameter will cause the device to send 
    * FavoritesListAvailable, FavoritesListCount &amp; FavoritesList
    */
    iAP2FavoritesListProperties* iAP2FavoritesListProperties;
    /**
     * \brief Number of occurrences of iAP2FavoritesListProperties parameter
     */
    U16 iAP2FavoritesListProperties_count;

    /**
    * \brief Recents List Combine
    *
    * Combine calls to the same person: Default = 1
    */
    U8* iAP2RecentListCombine;
    /**
     * \brief Number of occurrences of iAP2RecentListCombine parameter
     */
    U16 iAP2RecentListCombine_count;

    /**
    * \brief Recents List Properties
    *
    * Sending this parameter will cause the device to send
    * RecentsListAvailable RecentsListCount &amp; RecentsList
    */
    iAP2RecentsListProperties* iAP2RecentListProperties;
    /**
     * \brief Number of occurrences of iAP2RecentListProperties parameter
     */
    U16 iAP2RecentListProperties_count;

    /**
    * \brief Recents List Max
    *
    * Max entries to send; 0 = no limit
    */
    U16* iAP2RecentsListMax;
    /**
     * \brief Number of occurrences of iAP2RecentsListMax parameter
     */
    U16 iAP2RecentsListMax_count;

} iAP2StartListUpdatesParameter;

/**
 * \brief Parameter structure of StopCallStateUpdates message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopCallStateUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopCallStateUpdatesParameter;

/**
 * \brief Parameter structure of StopCommunicationsUpdates message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopCommunicationsUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopCommunicationsUpdatesParameter;

/**
 * \brief Parameter structure of StopListUpdates message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopListUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopListUpdatesParameter;

/**
 * \brief Parameter structure of SwapCalls message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for SwapCalls message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2SwapCallsParameter;

/**
 * \brief Parameter structure of DeviceAuthenticationCertificate message
 */
typedef struct
{
    /**
    * \brief Device's X.509 Certificate
    *
    * Authentication certificate from device
    */
    iAP2Blob* iAP2DeviceCertificate;
    /**
     * \brief Number of occurrences of iAP2DeviceCertificate parameter
     */
    U16 iAP2DeviceCertificate_count;

} iAP2DeviceAuthenticationCertificateParameter;

/**
 * \brief Parameter structure of DeviceAuthenticationFailed message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for DeviceAuthenticationFailed message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2DeviceAuthenticationFailedParameter;

/**
 * \brief Parameter structure of DeviceAuthenticationResponse message
 */
typedef struct
{
    /**
    * \brief Computed Challenge response
    *
    * Authentication challenge response computed for 
    * recieved challenge data
    */
    iAP2Blob* iAP2ChallengeResponse;
    /**
     * \brief Number of occurrences of iAP2ChallengeResponse parameter
     */
    U16 iAP2ChallengeResponse_count;

} iAP2DeviceAuthenticationResponseParameter;

/**
 * \brief Parameter structure of DeviceAuthenticationSucceeded message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for DeviceAuthenticationSucceeded message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2DeviceAuthenticationSucceededParameter;

/**
 * \brief Parameter structure of RequestDeviceAuthenticationCertificate message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for RequestDeviceAuthenticationCertificate message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2RequestDeviceAuthenticationCertificateParameter;

/**
 * \brief Parameter structure of RequestDeviceAuthenticationChallengeResponse message
 */
typedef struct
{
    /**
    * \brief Authentication Challenge response
    *
    * Challenge response retrieved from Authentication co-processor
    */
    iAP2Blob* iAP2DeviceAuthenticationChallenge;
    /**
     * \brief Number of occurrences of iAP2DeviceAuthenticationChallenge parameter
     */
    U16 iAP2DeviceAuthenticationChallenge_count;

} iAP2RequestDeviceAuthenticationChallengeResponseParameter;

/**
 * \brief Parameter structure of DeviceInformationUpdate message
 */
typedef struct
{
    /**
    * \brief Apple device name as shown in settings
    */
    U8** iAP2DeviceName;
    /**
     * \brief Number of occurrences of iAP2DeviceName parameter
     */
    U16 iAP2DeviceName_count;

} iAP2DeviceInformationUpdateParameter;

/**
 * \brief Parameter structure of DeviceLanguageUpdate message
 */
typedef struct
{
    /**
    * \brief ISO 639-1 or ISO 639-2 designation
    * for the current device language
    * 
    * According to the specification the name is DeviceLanguage
    */
    U8** iAP2DeviceName;
    /**
     * \brief Number of occurrences of iAP2DeviceName parameter
     */
    U16 iAP2DeviceName_count;

} iAP2DeviceLanguageUpdateParameter;

/**
 * \brief Parameter structure of DeviceTimeUpdate message
 */
typedef struct
{
    /**
    * \brief Daylight Savings Offset in Minutes
    */
    S8* iAP2DaylightSavingsOffsetMinutes;
    /**
     * \brief Number of occurrences of iAP2DaylightSavingsOffsetMinutes parameter
     */
    U16 iAP2DaylightSavingsOffsetMinutes_count;

    /**
    * \brief Time interval in seconds since
    * reference data (Jan 1, 1970, GMT)
    */
    U64* iAP2SecondsSinceReferenceDate;
    /**
     * \brief Number of occurrences of iAP2SecondsSinceReferenceDate parameter
     */
    U16 iAP2SecondsSinceReferenceDate_count;

    /**
    * \brief Difference in minutes between the
    * device time zone and GMT
    */
    S16* iAP2TimeZoneOffsetMinutes;
    /**
     * \brief Number of occurrences of iAP2TimeZoneOffsetMinutes parameter
     */
    U16 iAP2TimeZoneOffsetMinutes_count;

} iAP2DeviceTimeUpdateParameter;

/**
 * \brief Parameter structure of DeviceTransportIdentifierNotification message
 */
typedef struct
{
    /**
    * \brief iAP2 Bluetooth Transport Identifier
    */
    U8** iAP2BluetoothTransportIdentifier;
    /**
     * \brief Number of occurrences of iAP2BluetoothTransportIdentifier parameter
     */
    U16 iAP2BluetoothTransportIdentifier_count;

    /**
    * \brief iAP2 USB Transport Identifier
    */
    U8** iAP2USBTransportIdentifier;
    /**
     * \brief Number of occurrences of iAP2USBTransportIdentifier parameter
     */
    U16 iAP2USBTransportIdentifier_count;

} iAP2DeviceTransportIdentifierNotificationParameter;

/**
 * \brief Parameter structure of DeviceUUIDUpdate message
 */
typedef struct
{
    /**
    * \brief Device UUID
    *
    * It can be used by accessories to determine if they are connected
    * to the same device over multiple transports
    */
    U8** iAP2UUID;
    /**
     * \brief Number of occurrences of iAP2UUID parameter
     */
    U16 iAP2UUID_count;

} iAP2DeviceUUIDUpdateParameter;

/**
 * \brief Parameter structure of WirelessCarPlayUpdate message
 */
typedef struct
{
    /**
    * \brief Wireless CarPlay Update Status
    *
    */
    iAP2WirelessCarPlayUpdateStatus* iAP2Status;
    /**
     * \brief Number of occurrences of iAP2Status parameter
     */
    U16 iAP2Status_count;

} iAP2WirelessCarPlayUpdateParameter;

/**
 * \brief Parameter structure of StartExternalAccessoryProtocolSession message
 */
typedef struct
{
    /**
    * \brief External accessory Protocol Identifier
    *
    * It refers iAP2ExternalAccessoryProtocolIdentifier of iAP2ExternalAccessoryProtocol group
    */
    U8* iAP2ExternalAccesoryProtocolIdentifier;
    /**
     * \brief Number of occurrences of iAP2ExternalAccesoryProtocolIdentifier parameter
     */
    U16 iAP2ExternalAccesoryProtocolIdentifier_count;

    /**
    * \brief EAP session identifier to start External Accessory
    *
    * It is unique to each External accessory connection between App and accessory
    * It refers iAP2ExternalAccessoryProtocolIdentifier of iAP2ExternalAccessoryProtocol group.
    */
    U16* iAP2ExternalAccessoryProtocolSessionIdentifier;
    /**
     * \brief Number of occurrences of iAP2ExternalAccessoryProtocolSessionIdentifier parameter
     */
    U16 iAP2ExternalAccessoryProtocolSessionIdentifier_count;

} iAP2StartExternalAccessoryProtocolSessionParameter;

/**
 * \brief Parameter structure of StatusExternalAccessoryProtocolSession message
 */
typedef struct
{
    /**
    * \brief ExternalAccessoryProtocolSessionIdentifier of the App
    * whose status has to be sent to the iOS Device.
    */
    U16* iAP2ExternalAccessoryProtocolSessionIdentifier;
    /**
     * \brief Number of occurrences of iAP2ExternalAccessoryProtocolSessionIdentifier parameter
     */
    U16 iAP2ExternalAccessoryProtocolSessionIdentifier_count;

    /**
    * \brief status of the App.
    */
    iAP2ExternalAccessoryProtocolSessionStatus* iAP2ExternalAccessoryProtocolSessionStatus;
    /**
     * \brief Number of occurrences of iAP2ExternalAccessoryProtocolSessionStatus parameter
     */
    U16 iAP2ExternalAccessoryProtocolSessionStatus_count;

} iAP2StatusExternalAccessoryProtocolSessionParameter;

/**
 * \brief Parameter structure of StopExternalAccessoryProtocolSession message
 */
typedef struct
{
    /**
    * \brief External accessory Protocol Identifier
    *
    * It refers iAP2ExternalAccessoryProtocolIdentifier of iAP2ExternalAccessoryProtocol group
    */
    U16* iAP2ExternalAccessoryProtocolSessionIdentifier;
    /**
     * \brief Number of occurrences of iAP2ExternalAccessoryProtocolSessionIdentifier parameter
     */
    U16 iAP2ExternalAccessoryProtocolSessionIdentifier_count;

} iAP2StopExternalAccessoryProtocolSessionParameter;

/**
 * \brief Parameter structure of AccessoryHIDReport message
 */
typedef struct
{
    /**
    * \brief HID Component Identifier
    *
    * It must refer to an identified iAP2HIDComponent
    */
    U16* iAP2HIDComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2HIDComponentIdentifier parameter
     */
    U16 iAP2HIDComponentIdentifier_count;

    /**
    * \brief HID Control data
    */
    iAP2Blob* iAP2HIDReport;
    /**
     * \brief Number of occurrences of iAP2HIDReport parameter
     */
    U16 iAP2HIDReport_count;

} iAP2AccessoryHIDReportParameter;

/**
 * \brief Parameter structure of DeviceHIDReport message
 */
typedef struct
{
    /**
    * \brief HID Component Identifier
    *
    * It must refer to an identified iAP2HIDComponent
    */
    U16* iAP2HIDComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2HIDComponentIdentifier parameter
     */
    U16 iAP2HIDComponentIdentifier_count;

    /**
    * \brief HID Control data
    */
    iAP2Blob* iAP2HIDReport;
    /**
     * \brief Number of occurrences of iAP2HIDReport parameter
     */
    U16 iAP2HIDReport_count;

} iAP2DeviceHIDReportParameter;

/**
 * \brief Parameter structure of StartHID message
 */
typedef struct
{
    /**
    * \brief HIDComponentIdentifier
    *
    * It must correspond to an identified iAP2HIDComponent
    */
    U16* iAP2HIDComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2HIDComponentIdentifier parameter
     */
    U16 iAP2HIDComponentIdentifier_count;

    /**
    * \brief HID Report descriptor
    *
    * Set of values that describe HID reports
    */
    iAP2Blob* iAP2HIDReportDescriptor;
    /**
     * \brief Number of occurrences of iAP2HIDReportDescriptor parameter
     */
    U16 iAP2HIDReportDescriptor_count;

    /**
    * \brief Country code of localized keyboard
    *
    * Only required if the HID component is a localized keyboard
    */
    U8* iAP2LocalizedKeyboardCountryCode;
    /**
     * \brief Number of occurrences of iAP2LocalizedKeyboardCountryCode parameter
     */
    U16 iAP2LocalizedKeyboardCountryCode_count;

    /**
    * \brief Product ID of the HID component
    *
    * Must be unique for each accessory made by the accessory manufacturer
    */
    U16* iAP2ProductIdentifier;
    /**
     * \brief Number of occurrences of iAP2ProductIdentifier parameter
     */
    U16 iAP2ProductIdentifier_count;

    /**
    * \brief Vendor ID of the HID component
    *
    * Must be assigned and registered by USB-IF for the accessory manufacturer
    */
    U16* iAP2VendorIdentifier;
    /**
     * \brief Number of occurrences of iAP2VendorIdentifier parameter
     */
    U16 iAP2VendorIdentifier_count;

} iAP2StartHIDParameter;

/**
 * \brief Parameter structure of StartNativeHID message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StartNativeHID message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StartNativeHIDParameter;

/**
 * \brief Parameter structure of StopHID message
 */
typedef struct
{
    /**
    * \brief HID Component Identifier
    *
    * It must refer to an identified iAP2HIDComponent
    */
    U16* iAP2HIDComponentIdentifier;
    /**
     * \brief Number of occurrences of iAP2HIDComponentIdentifier parameter
     */
    U16 iAP2HIDComponentIdentifier_count;

} iAP2StopHIDParameter;

/**
 * \brief Parameter structure of GPRMCDataStatusValuesNotification message
 */
typedef struct
{
    /**
    * \brief If present, the accessory may report GPRMC Data Status * field as 'A'
    */
    U8* iAP2GPRMCDataStatusValueA;
    /**
     * \brief Number of occurrences of iAP2GPRMCDataStatusValueA parameter
     */
    U16 iAP2GPRMCDataStatusValueA_count;

    /**
    * \brief If present, the accessory may report GPRMC Data Status * field as 'V'
    */
    
    
    U8* iAP2GPRMCDataStatusValueV;
    /**
     * \brief Number of occurrences of iAP2GPRMCDataStatusValueV parameter
     */
    U16 iAP2GPRMCDataStatusValueV_count;

    /**
    * \brief If present, the accessory may report GPRMC Data Status * * field as 'X'
    */
    
    
    
    U8* iAP2GPRMCDataStatusValueX;
    /**
     * \brief Number of occurrences of iAP2GPRMCDataStatusValueX parameter
     */
    U16 iAP2GPRMCDataStatusValueX_count;

} iAP2GPRMCDataStatusValuesNotificationParameter;

/**
 * \brief Parameter structure of LocationInformation message
 */
typedef struct
{
    /**
    * \brief one or more NMEA sentences specified by StartLocationInformation
    *
    * It must be live GPS data
    */
    U8** iAP2NMEASentence;
    /**
     * \brief Number of occurrences of iAP2NMEASentence parameter
     */
    U16 iAP2NMEASentence_count;

} iAP2LocationInformationParameter;

/**
 * \brief Parameter structure of StartLocationInformation message
 */
typedef struct
{
    /**
    * \brief Minimal interval between LocationInformation messages
    */
    U8* iAP2GlobalPositioningSystemFixData;
    /**
     * \brief Number of occurrences of iAP2GlobalPositioningSystemFixData parameter
     */
    U16 iAP2GlobalPositioningSystemFixData_count;

    /**
    * \brief If present, accessory may provide NMEA GPGSV sentences
    */
    U8* iAP2GPSSatellitesInView;
    /**
     * \brief Number of occurrences of iAP2GPSSatellitesInView parameter
     */
    U16 iAP2GPSSatellitesInView_count;

    /**
    * \brief If present, accessory may provide NMEA GPRMC sentences
    */
    U8* iAP2RecommendedMinimumSpecificGPSTransitData;
    /**
     * \brief Number of occurrences of iAP2RecommendedMinimumSpecificGPSTransitData parameter
     */
    U16 iAP2RecommendedMinimumSpecificGPSTransitData_count;

    /**
    * \brief If present, accessory may provide NMEA PAACD sentences
    */
    U8* iAP2VehicleAccelerometerData;
    /**
     * \brief Number of occurrences of iAP2VehicleAccelerometerData parameter
     */
    U16 iAP2VehicleAccelerometerData_count;

    /**
    * \brief If present, Accessory may provide NMEA PAGCD sentences
    */
    U8* iAP2VehicleGyroData;
    /**
     * \brief Number of occurrences of iAP2VehicleGyroData parameter
     */
    U16 iAP2VehicleGyroData_count;

    /**
    * \brief If present, accessory may provide NMEA GPHDT sentences
    */
    U8* iAP2VehicleHeadingData;
    /**
     * \brief Number of occurrences of iAP2VehicleHeadingData parameter
     */
    U16 iAP2VehicleHeadingData_count;

    /**
    * \brief If present, accessory may provide NMEA PASCD sentences
    */
    U8* iAP2VehicleSpeedData;
    /**
     * \brief Number of occurrences of iAP2VehicleSpeedData parameter
     */
    U16 iAP2VehicleSpeedData_count;

} iAP2StartLocationInformationParameter;

/**
 * \brief Parameter structure of StopLocationInformation message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopLocationInformation message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopLocationInformationParameter;

/**
 * \brief Parameter structure of MediaLibraryInformation message
 */
typedef struct
{
    /**
    * \brief Media Library Information SubParameter of type group
    */
    iAP2MediaLibraryInformationSubParameter* iAP2MediaLibraryInformationSubParameter;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryInformationSubParameter parameter
     */
    U16 iAP2MediaLibraryInformationSubParameter_count;

} iAP2MediaLibraryInformationParameter;

/**
 * \brief Parameter structure of MediaLibraryUpdate message
 */
typedef struct
{
    /**
    * \brief List of Media Items
    *
    * Media Items details
    */
    iAP2MediaItem* iAP2MediaItem;
    /**
     * \brief Number of occurrences of iAP2MediaItem parameter
     */
    U16 iAP2MediaItem_count;

    /**
    * \brief Persistent identifier of the media item that has been deleted
    */
    U64* iAP2MediaItemDeletePersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaItemDeletePersistentIdentifier parameter
     */
    U16 iAP2MediaItemDeletePersistentIdentifier_count;

    /**
    * \brief If present, Apple device's UI is presenting only media items that are resident on device
    */
    U8* iAP2MediaLibraryIsHidingRemoteItems;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryIsHidingRemoteItems parameter
     */
    U16 iAP2MediaLibraryIsHidingRemoteItems_count;

    /**
    * \brief If present, Accessory must delete all data 
    * pertaining to specified media library before applying new updates
    */
    U8* iAP2MediaLibraryReset;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryReset parameter
     */
    U16 iAP2MediaLibraryReset_count;

    /**
    * \brief Media Library Revision(Null terminated utf-8 string)
    */
    U8** iAP2MediaLibraryRevision;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryRevision parameter
     */
    U16 iAP2MediaLibraryRevision_count;

    /**
    * \brief Media Library Unique Identifier
    *
    * Refers iAP2MediaLibraryInformationSubParameter of iAP2MediaLibraryInformationParameter
    */
    U8** iAP2MediaLibraryUniqueIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryUniqueIdentifier parameter
     */
    U16 iAP2MediaLibraryUniqueIdentifier_count;

    /**
    * \brief If present, indicates the percentage completion of current set of media library updates
    */
    U8* iAP2MediaLibraryUpdateProgress;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryUpdateProgress parameter
     */
    U16 iAP2MediaLibraryUpdateProgress_count;

    /**
    * \brief playlist details
    */
    iAP2MediaPlayList* iAP2MediaPlayList;
    /**
     * \brief Number of occurrences of iAP2MediaPlayList parameter
     */
    U16 iAP2MediaPlayList_count;

    /**
    * \brief Persistent identifier of the playlist that has been deleted
    */
    U64* iAP2MediaPlaylistDeletePersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistDeletePersistentIdentifier parameter
     */
    U16 iAP2MediaPlaylistDeletePersistentIdentifier_count;

    /**
    * \brief If present, Apple device is capable of playing all songs.
    */
    U8* iAP2PlayAllSongsCapable;
    /**
     * \brief Number of occurrences of iAP2PlayAllSongsCapable parameter
     */
    U16 iAP2PlayAllSongsCapable_count;

} iAP2MediaLibraryUpdateParameter;

/**
 * \brief Parameter structure of PlayMediaLibraryCollection message
 */
typedef struct
{
    /**
    * \brief Media Library Collection persistent Identifier
    */
    U64* iAP2CollectionPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2CollectionPersistentIdentifier parameter
     */
    U16 iAP2CollectionPersistentIdentifier_count;

    /**
    * \brief Index of the first item in Collection to start playback with. 
    *
    * If the parameter is invalid or not present, the starting index defaults to 0
    */
    U32* iAP2CollectionStartingIndex;
    /**
     * \brief Number of occurrences of iAP2CollectionStartingIndex parameter
     */
    U16 iAP2CollectionStartingIndex_count;

    /**
    * \brief Media Library Collection of type enum
    */
    iAP2MediaLibraryCollectionType* iAP2CollectionType;
    /**
     * \brief Number of occurrences of iAP2CollectionType parameter
     */
    U16 iAP2CollectionType_count;

    /**
    * \brief Media Library Unique Identifier
    *
    * Refers iAP2MediaLibraryInformationSubParameter of iAP2MediaLibraryInformationParameter
    */
    U8** iAP2MediaLibraryUniqueIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryUniqueIdentifier parameter
     */
    U16 iAP2MediaLibraryUniqueIdentifier_count;

    /**
    * \brief Media Item Persistent Identifier
    * To specify the starting of the track.
    * If invalid or not present, the starting item defaults to the first item.
    */
    U64* iAP2StartingMediaItemPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2StartingMediaItemPersistentIdentifier parameter
     */
    U16 iAP2StartingMediaItemPersistentIdentifier_count;

} iAP2PlayMediaLibraryCollectionParameter;

/**
 * \brief Parameter structure of PlayMediaLibraryCurrentSelection message
 */
typedef struct
{
    /**
    * \brief Media Library Unique Identifier
    *
    * Refers MediaLibraryUniqueIdentifier of MediaLibraryInformation
    */
    U8** MediaLibraryUniqueIdentifier;
    /**
     * \brief Number of occurrences of MediaLibraryUniqueIdentifier parameter
     */
    U16 MediaLibraryUniqueIdentifier_count;

} iAP2PlayMediaLibraryCurrentSelectionParameter;

/**
 * \brief Parameter structure of PlayMediaLibraryItems message
 */
typedef struct
{
    /**
    * \brief Array of ordered Media Item PersistentIdentifiers
    *
    * Must refer iAP2MediaLibraryUniqueIdentifierMLBUpdate of iAP2MediaLibraryUpdateParameter
    */
    iAP2Blob* iAP2ItemsPersistentIdentifiers;
    /**
     * \brief Number of occurrences of iAP2ItemsPersistentIdentifiers parameter
     */
    U16 iAP2ItemsPersistentIdentifiers_count;

    /**
    * \brief Starting playback Index
    *
    * If it is invalid or not present, the starting index defaults to 0
    */
    U32* ItemsStartingIndex;
    /**
     * \brief Number of occurrences of ItemsStartingIndex parameter
     */
    U16 ItemsStartingIndex_count;

    /**
    * \brief Media Library Unique Identifier
    *
    * Refers MediaLibraryUniqueIdentifier of MediaLibraryInformation
    */
    U8** MediaLibraryUniqueIdentifier;
    /**
     * \brief Number of occurrences of MediaLibraryUniqueIdentifier parameter
     */
    U16 MediaLibraryUniqueIdentifier_count;

} iAP2PlayMediaLibraryItemsParameter;

/**
 * \brief Parameter structure of PlayMediaLibrarySpecial message
 */
typedef struct
{
    /**
    * \brief Asks iOS Devices to Play All Songs
    */
    U8* iAP2AllSongs;
    /**
     * \brief Number of occurrences of iAP2AllSongs parameter
     */
    U16 iAP2AllSongs_count;

    /**
    * \brief Media Library Unique Identifier
    *
    * Refers MediaLibraryUniqueIdentifier of MediaLibraryInformation
    */
    U8** iAP2MediaLibraryUniqueIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryUniqueIdentifier parameter
     */
    U16 iAP2MediaLibraryUniqueIdentifier_count;

    /**
    * \brief Media Item Persistent Identifier
    * To specify the starting of the track.
    * If invalid or not present, the starting item defaults to the first item.
    */
    U64* iAP2StartingMediaItemPersistentIdentifier;
    /**
     * \brief Number of occurrences of iAP2StartingMediaItemPersistentIdentifier parameter
     */
    U16 iAP2StartingMediaItemPersistentIdentifier_count;

} iAP2PlayMediaLibrarySpecialParameter;

/**
 * \brief Parameter structure of StartMediaLibraryInformation message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StartMediaLibraryInformation message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StartMediaLibraryInformationParameter;

/**
 * \brief Parameter structure of StartMediaLibraryUpdates message
 */
typedef struct
{
    /**
    * \brief Last received Media Library Revision
    *
    * If no LastKnownMediaLibraryRevision is included, a full database update will be sent.
    */
    U8** iAP2LastKnownMediaLibraryRevision;
    /**
     * \brief Number of occurrences of iAP2LastKnownMediaLibraryRevision parameter
     */
    U16 iAP2LastKnownMediaLibraryRevision_count;

    /**
    * \brief MediaProperties of type group
    *
    * It must be declared to receive arbitrary list of Media Library Items
    * each media item in the apple device
    */
    iAP2MediaItemProperties* iAP2MediaItemProperties;
    /**
     * \brief Number of occurrences of iAP2MediaItemProperties parameter
     */
    U16 iAP2MediaItemProperties_count;

    /**
    * \brief Media items that are resident on device
    */
    U8* iAP2MediaLibraryIsHidingRemoteItems;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryIsHidingRemoteItems parameter
     */
    U16 iAP2MediaLibraryIsHidingRemoteItems_count;

    /**
    * \brief Media Library Unique Identifier
    *
    * Refers MediaLibraryUniqueIdentifier of MediaLibraryInformation
    */
    U8** iAP2MediaLibraryUniqueIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryUniqueIdentifier parameter
     */
    U16 iAP2MediaLibraryUniqueIdentifier_count;

    /**
    * \brief Media Library Update Progress
    *
    * Percent completion of current set of media library updates from device
    */
    U8* iAP2MediaLibraryUpdateProgress;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryUpdateProgress parameter
     */
    U16 iAP2MediaLibraryUpdateProgress_count;

    /**
    * \brief MediaPlaylistProperties of type group
    *
    * It must be declared to receive Media library Playlist
    */
    iAP2MediaPlaylistProperties* iAP2MediaPlaylistProperties;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistProperties parameter
     */
    U16 iAP2MediaPlaylistProperties_count;

    /**
    * \brief Play All Songs Capable
    *
    * It must be declared to to know whether the iOS Device is capable of playing all songs or not
    */
    U8* iAP2PlayAllSongsCapable;
    /**
     * \brief Number of occurrences of iAP2PlayAllSongsCapable parameter
     */
    U16 iAP2PlayAllSongsCapable_count;

    /**
    * \brief MediaPlaylistContentTransferInfoRequest of type group
    *
    */
    iAP2MediaPlaylistContentTransferInfoRequest* iAP2MediaPlaylistContentTransferInfoRequest;
    /**
     * \brief Number of occurrences of iAP2MediaPlaylistContentTransferInfoRequest parameter
     */
    U16 iAP2MediaPlaylistContentTransferInfoRequest_count;

} iAP2StartMediaLibraryUpdatesParameter;

/**
 * \brief Parameter structure of StopMediaLibraryInformation message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopMediaLibraryInformation message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopMediaLibraryInformationParameter;

/**
 * \brief Parameter structure of StopMediaLibraryUpdates message
 */
typedef struct
{
    /**
    * \brief Media Library Unique Identifier
    *
    * Refers iAP2MediaLibraryInformationSubParameter of iAP2MediaLibraryInformationParameter
    */
    U8** iAP2MediaLibraryUniqueIdentifier;
    /**
     * \brief Number of occurrences of iAP2MediaLibraryUniqueIdentifier parameter
     */
    U16 iAP2MediaLibraryUniqueIdentifier_count;

} iAP2StopMediaLibraryUpdatesParameter;

/**
 * \brief Parameter structure of NowPlayingUpdate message
 */
typedef struct
{
    /**
    * \brief List of attributes of now playing item
    *
    * Refers to the group iAP2StartNowPlayingMediaItemAttributes or MediaItem
    */
    iAP2MediaItem* iAP2MediaItemAttributes;
    /**
     * \brief Number of occurrences of iAP2MediaItemAttributes parameter
     */
    U16 iAP2MediaItemAttributes_count;

    /**
    * \brief Playback engine state
    *
    * Refers to the group iAP2StartNowPlayingPlaybackAttributes
    */
    iAP2PlaybackAttributes* iAP2PlaybackAttributes;
    /**
     * \brief Number of occurrences of iAP2PlaybackAttributes parameter
     */
    U16 iAP2PlaybackAttributes_count;

} iAP2NowPlayingUpdateParameter;

/**
 * \brief Parameter structure of SetNowPlayingInformation message
 */
typedef struct
{
    /**
    * \brief Application should send this value if it wants to set Elapsed time of the playing song.
    * Only Effective if NowPlayingUpdate message SetElapsedTimeAvail parameter is true.
    */
    U32* iAP2ElapsedTime;
    /**
     * \brief Number of occurrences of iAP2ElapsedTime parameter
     */
    U16 iAP2ElapsedTime_count;

    /**
    * \brief Playback Queue Index obtained from NowPlayingUpdate.
    */
    U32* iAP2PlaybackQueueIndex;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueIndex parameter
     */
    U16 iAP2PlaybackQueueIndex_count;

    /**
    * \brief The starting index of the PlaybackQueueListContentTransfer list.
    * If set to max uint32 value of 0xFFFFFFFF, an index will be chosen by the Apple device.
    * The start index will be chosen so that the current track index will be in the middle of PlaybackQueueListContentTransferSize.
    */
    U32* iAP2PlaybackQueueListContentTransferStartIndex;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueListContentTransferStartIndex parameter
     */
    U16 iAP2PlaybackQueueListContentTransferStartIndex_count;

} iAP2SetNowPlayingInformationParameter;

/**
 * \brief Parameter structure of StartNowPlayingUpdates message
 */
typedef struct
{
    /**
    * \brief List of attributes of now playing item that wish to receive
    *
    * Refers to the group iAP2MediaItemAttributes
    */
    iAP2MediaItemAttributes* iAP2MediaItemAttributes;
    /**
     * \brief Number of occurrences of iAP2MediaItemAttributes parameter
     */
    U16 iAP2MediaItemAttributes_count;

    /**
    * \brief List of attributes of media playback engine that wish to receive
    *
    * Refers to the group iAP2MediaPlaybackAttributes
    */
    iAP2StartNowPlayingPlaybackAttributes* iAP2PlaybackAttributes;
    /**
     * \brief Number of occurrences of iAP2PlaybackAttributes parameter
     */
    U16 iAP2PlaybackAttributes_count;

    
    iAP2PlaybackQueueListContentTransferInfoRequest* iAP2PlaybackQueueListContentTransferInfoRequest;
    /**
     * \brief Number of occurrences of iAP2PlaybackQueueListContentTransferInfoRequest parameter
     */
    U16 iAP2PlaybackQueueListContentTransferInfoRequest_count;

} iAP2StartNowPlayingUpdatesParameter;

/**
 * \brief Parameter structure of StopNowPlayingUpdates message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopNowPlayingUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopNowPlayingUpdatesParameter;

/**
 * \brief Parameter structure of PowerSourceUpdate message
 */
typedef struct
{
    /**
    * \brief Available Current for device
    
    * Must be one of the following
    * 0
    * 1000
    * 2100
    * 2400
    */
    U16* iAP2AvailableCurrentForDevice;
    /**
     * \brief Number of occurrences of iAP2AvailableCurrentForDevice parameter
     */
    U16 iAP2AvailableCurrentForDevice_count;

    /**
    * \brief TRUE if Device Battery Should Charge if power is present
    */
    U8* iAP2DeviceBatteryShouldChargeIfPowerIsPresent;
    /**
     * \brief Number of occurrences of iAP2DeviceBatteryShouldChargeIfPowerIsPresent parameter
     */
    U16 iAP2DeviceBatteryShouldChargeIfPowerIsPresent_count;

} iAP2PowerSourceUpdateParameter;

/**
 * \brief Parameter structure of PowerUpdate message
 */
typedef struct
{
    /**
    * \brief Accessory power mode
    */
    iAP2AccessoryPowerModes* iAP2AccessoryPowerMode;
    /**
     * \brief Number of occurrences of iAP2AccessoryPowerMode parameter
     */
    U16 iAP2AccessoryPowerMode_count;

    /**
    * \brief Provides information on Battery Charging Level (0 -100)
    */
    U16* iAP2BatteryChargeLevel;
    /**
     * \brief Number of occurrences of iAP2BatteryChargeLevel parameter
     */
    U16 iAP2BatteryChargeLevel_count;

    /**
    * \brief Provides information on Battery Charging State (Charging / Trickle / Charged)
    */
    iAP2BatteryChargingState* iAP2BatteryChargingState;
    /**
     * \brief Number of occurrences of iAP2BatteryChargingState parameter
     */
    U16 iAP2BatteryChargingState_count;

    /**
    * \brief TRUE if Apple device battery will charge if power is present
    */
    U8* iAP2DeviceBatteryWillChargeIfPowerIsPresent;
    /**
     * \brief Number of occurrences of iAP2DeviceBatteryWillChargeIfPowerIsPresent parameter
     */
    U16 iAP2DeviceBatteryWillChargeIfPowerIsPresent_count;

    /**
    * \brief Provides information when an external charger is
    * connected or disconnected.
    */
    U8* iAP2IsExternalChargerConnected;
    /**
     * \brief Number of occurrences of iAP2IsExternalChargerConnected parameter
     */
    U16 iAP2IsExternalChargerConnected_count;

    /**
    * \brief Maximum current Apple device will draw from accessory
    */
    U16* iAP2MaximumCurrentDrawnFromAccessory;
    /**
     * \brief Number of occurrences of iAP2MaximumCurrentDrawnFromAccessory parameter
     */
    U16 iAP2MaximumCurrentDrawnFromAccessory_count;

} iAP2PowerUpdateParameter;

/**
 * \brief Parameter structure of StartPowerUpdates message
 */
typedef struct
{
    /**
    * \brief Get Accessory power mode
    *
    * It must be present if and only if the accessory draws power from apple device
    */
    U8* iAP2AccessoryPowerMode;
    /**
     * \brief Number of occurrences of iAP2AccessoryPowerMode parameter
     */
    U16 iAP2AccessoryPowerMode_count;

    /**
    * \brief If Application wants to know the Battery 
    * Charge level of the iOS Device it should set this.
    */
    U8* iAP2BatteryChargeLevel;
    /**
     * \brief Number of occurrences of iAP2BatteryChargeLevel parameter
     */
    U16 iAP2BatteryChargeLevel_count;

    /**
    * \brief If Application wants to know the Battery 
    * Charging State of the iOS Device it should set this.
    */
    U8* iAP2BatteryChargingState;
    /**
     * \brief Number of occurrences of iAP2BatteryChargingState parameter
     */
    U16 iAP2BatteryChargingState_count;

    /**
    * \brief If present, receive whether Device battery will charge if power present
    */
    U8* iAP2DeviceBatteryWillChargeIfPowerIsPresent;
    /**
     * \brief Number of occurrences of iAP2DeviceBatteryWillChargeIfPowerIsPresent parameter
     */
    U16 iAP2DeviceBatteryWillChargeIfPowerIsPresent_count;

    /**
    * \brief If Application wants to whether iOS Device is 
    * connected to the External Charger it should set this.
    */
    U8* iAP2IsExternalChargerConnected;
    /**
     * \brief Number of occurrences of iAP2IsExternalChargerConnected parameter
     */
    U16 iAP2IsExternalChargerConnected_count;

    /**
    * \brief If present, Get maximum current apple device will draw from accessory
    */
    U8* iAP2MaximumcurrentDrawnFromAccessory;
    /**
     * \brief Number of occurrences of iAP2MaximumcurrentDrawnFromAccessory parameter
     */
    U16 iAP2MaximumcurrentDrawnFromAccessory_count;

} iAP2StartPowerUpdatesParameter;

/**
 * \brief Parameter structure of StopPowerUpdates message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopPowerUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopPowerUpdatesParameter;

/**
 * \brief Parameter structure of StartTelephonyCallStateInformation message
 * The Structure iAP2StartTelephonyCallStateInformationParameter is Deprecated, Don't use it. Kindly refer the Apple Specification.
 */
typedef struct
{
    /**
    * \brief Present if application wish to receive vCard from device
    */
    U8* iAP2CallStatevCardFileTransferIdentifier;
    /**
     * \brief Number of occurrences of iAP2CallStatevCardFileTransferIdentifier parameter
     */
    U16 iAP2CallStatevCardFileTransferIdentifier_count;

} iAP2StartTelephonyCallStateInformationParameter;

/**
 * \brief Parameter structure of StartTelephonyUpdates message
 * The Structure iAP2StartTelephonyUpdatesParameter is Deprecated, Don't use it. Kindly refer the Apple Specification.
 */
typedef struct
{
    /**
    * \brief Present if application wish to receive Signal Strength
    */
    U8* iAP2TelephonySignalStrength;
    /**
     * \brief Number of occurrences of iAP2TelephonySignalStrength parameter
     */
    U16 iAP2TelephonySignalStrength_count;

    /**
    * \brief Present if application wish to receive Registration status
    */
    U8* iAP2TelephonyRegistrationStatus;
    /**
     * \brief Number of occurrences of iAP2TelephonyRegistrationStatus parameter
     */
    U16 iAP2TelephonyRegistrationStatus_count;

    /**
    * \brief Present if application wish to know whether Airplane Mode set or not
    */
    U8* iAP2TelephonyAirplaneModeStatus;
    /**
     * \brief Number of occurrences of iAP2TelephonyAirplaneModeStatus parameter
     */
    U16 iAP2TelephonyAirplaneModeStatus_count;

    /**
    * \brief Present if application wish to receive TTY status from device
    */
    U8* iAP2TelephonyTTYStatus;
    /**
     * \brief Number of occurrences of iAP2TelephonyTTYStatus parameter
     */
    U16 iAP2TelephonyTTYStatus_count;

    /**
    * \brief Present if application wish to receive Name of mobile operator
    */
    U8* iAP2TelephonyMobileOperator;
    /**
     * \brief Number of occurrences of iAP2TelephonyMobileOperator parameter
     */
    U16 iAP2TelephonyMobileOperator_count;

} iAP2StartTelephonyUpdatesParameter;

/**
 * \brief Parameter structure of StopTelephonyCallStateInformation message
 * The Structure iAP2StopTelephonyCallStateInformationParameter is Deprecated, Don't use it. Kindly refer the Apple Specification.
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopTelephonyCallStateInformation message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopTelephonyCallStateInformationParameter;

/**
 * \brief Parameter structure of StopTelephonyUpdates message
 * The Structure iAP2StopTelephonyUpdatesParameter is Deprecated, Don't use it. Kindly refer the Apple Specification.
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopTelephonyUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopTelephonyUpdatesParameter;

/**
 * \brief Parameter structure of TelephonyCallStateInformation message
 * The Structure iAP2TelephonyCallStateInformationParameter is Deprecated, Don't use it. Kindly refer the Apple Specification.
 */
typedef struct
{
    /**
    * \brief calling party's Phone number
    */
    U8** iAP2CallStatePhoneNumber;
    /**
     * \brief Number of occurrences of iAP2CallStatePhoneNumber parameter
     */
    U16 iAP2CallStatePhoneNumber_count;

    /**
    * \brief calling party's name
    */
    U8** iAP2CallStateCallerName;
    /**
     * \brief Number of occurrences of iAP2CallStateCallerName parameter
     */
    U16 iAP2CallStateCallerName_count;

    /**
    * \brief Call state
    *
    * Disconnected or active or waiting or connecting
    */
    iAP2CallStateStatusValue* iAP2CallStateStatus;
    /**
     * \brief Number of occurrences of iAP2CallStateStatus parameter
     */
    U16 iAP2CallStateStatus_count;

    /**
    * \brief Call state direction, Incoming or Outgoing 
    *
    * It refers to enum iAP2CallStateDirectionValue
    */
    iAP2CallStateDirectionValue* iAP2CallStateDirection;
    /**
     * \brief Number of occurrences of iAP2CallStateDirection parameter
     */
    U16 iAP2CallStateDirection_count;

    /**
    * \brief Unique call ID
    *
    * Differentiates between cellular and data calls from same contact as well as conference calls
    */
    U8** iAP2UniqueCallID;
    /**
     * \brief Number of occurrences of iAP2UniqueCallID parameter
     */
    U16 iAP2UniqueCallID_count;

    /**
    * \brief vCard Transfer Identifier
    */
    U8* iAP2CallStatevCardFileTransferIdentifier;
    /**
     * \brief Number of occurrences of iAP2CallStatevCardFileTransferIdentifier parameter
     */
    U16 iAP2CallStatevCardFileTransferIdentifier_count;

} iAP2TelephonyCallStateInformationParameter;

/**
 * \brief Parameter structure of TelephonyUpdate message
 * The Structure iAP2TelephonyUpdateParameter is Deprecated, Don't use it. Kindly refer the Apple Specification.
 */
typedef struct
{
    /**
    * @brief Signal Strength
    *
    * It refers to enum iAP2TelephonySignalStrengthValue
    * It will always be zero when the device is in airplane mode
    */
    iAP2TelephonySignalStrengthValue* iAP2TelephonySignalStrength;
    /**
     * \brief Number of occurrences of iAP2TelephonySignalStrength parameter
     */
    U16 iAP2TelephonySignalStrength_count;

    /**
    * @brief Registration status
    *
    * It refers to enum iAP2TelephonyRegistrationStatusValue
    */
    iAP2TelephonyRegistrationStatusValue* iAP2TelephonyRegistrationStatus;
    /**
     * \brief Number of occurrences of iAP2TelephonyRegistrationStatus parameter
     */
    U16 iAP2TelephonyRegistrationStatus_count;

    /**
    * @brief TRUE if Airplane mode is set
    */
    U8* iAP2TelephonyAirplaneModeStatus;
    /**
     * \brief Number of occurrences of iAP2TelephonyAirplaneModeStatus parameter
     */
    U16 iAP2TelephonyAirplaneModeStatus_count;

    /**
    * @brief TRUE if TTY is set
    */
    U8* iAP2TelephonyTTYStatus;
    /**
     * \brief Number of occurrences of iAP2TelephonyTTYStatus parameter
     */
    U16 iAP2TelephonyTTYStatus_count;

    /**
    * @brief Name of mobile operator
    *
    * Null terminated utf-8 string
    */
    U8** iAP2TelephonyMobileOperator;
    /**
     * \brief Number of occurrences of iAP2TelephonyMobileOperator parameter
     */
    U16 iAP2TelephonyMobileOperator_count;

} iAP2TelephonyUpdateParameter;

/**
 * \brief Parameter structure of StartUSBDeviceModeAudio message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StartUSBDeviceModeAudio message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StartUSBDeviceModeAudioParameter;

/**
 * \brief Parameter structure of StopUSBDeviceModeAudio message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopUSBDeviceModeAudio message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopUSBDeviceModeAudioParameter;

/**
 * \brief Parameter structure of USBDeviceModeAudioInformation message
 */
typedef struct
{
    /**
    * \brief Audio Sample Rate
    *
    * Refers to enum USBDeviceModeAudioSampleRate
    */
    iAP2USBDeviceModeAudioSampleRate* iAP2SampleRate;
    /**
     * \brief Number of occurrences of iAP2SampleRate parameter
     */
    U16 iAP2SampleRate_count;

} iAP2USBDeviceModeAudioInformationParameter;

/**
 * \brief Parameter structure of StartVehicleStatusUpdates message
 */
typedef struct
{
    /* The Parameter NightMode is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief  Present if application wish to receive Vehicle's night mode status
    */
    U8* iAP2NightMode;
    /**
     * \brief Number of occurrences of iAP2NightMode parameter
     */
    U16 iAP2NightMode_count;

    /**
    * \brief Present if application wish to receive Vehicle's Range in Kms
    */
    U8* iAP2Range;
    /**
     * \brief Number of occurrences of iAP2Range parameter
     */
    U16 iAP2Range_count;

    /* The Parameter InsideTemperature is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief  Present if application wish to receive Vehicle's Inside Temperature(in Degree Celsius)
    */
    U8* iAP2InsideTemperature;
    /**
     * \brief Number of occurrences of iAP2InsideTemperature parameter
     */
    U16 iAP2InsideTemperature_count;

    /**
    * \brief Present if application wish to receive  Vehicle's Outside Temperature(in Degree Celsius)
    */
    U8* iAP2OutsideTemperature;
    /**
     * \brief Number of occurrences of iAP2OutsideTemperature parameter
     */
    U16 iAP2OutsideTemperature_count;

    /**
    * \brief Present if application wish to receive Vehicle's low range warning
    */
    U8* iAP2RangeWarning;
    /**
     * \brief Number of occurrences of iAP2RangeWarning parameter
     */
    U16 iAP2RangeWarning_count;

} iAP2StartVehicleStatusUpdatesParameter;

/**
 * \brief Parameter structure of StopVehicleStatusUpdates message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopVehicleStatusUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopVehicleStatusUpdatesParameter;

/**
 * \brief Parameter structure of VehicleStatusUpdate message
 */
typedef struct
{
    /* The Parameter NightMode is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief TRUE or FALSE
    *
    * If TRUE, vehicle is in night mode. If FALSE, vehicle is in day mode
    */
    U8* iAP2NightMode;
    /**
     * \brief Number of occurrences of iAP2NightMode parameter
     */
    U16 iAP2NightMode_count;

    /**
    * \brief Remaining vehicle Range in Kilometers.
    */
    U16* iAP2Range;
    /**
     * \brief Number of occurrences of iAP2Range parameter
     */
    U16 iAP2Range_count;

    /**
    * \brief Measured Outside temperature in degrees celsius
    */
    S16* iAP2OutsideTemperature;
    /**
     * \brief Number of occurrences of iAP2OutsideTemperature parameter
     */
    U16 iAP2OutsideTemperature_count;

    /* The Parameter InsideTemperature is Deprecated, Don't use it. Kindly refer the Apple specification. */
    /**
    * \brief Measured inside temperature in degrees celsius
    */
    S16* iAP2InsideTemperature;
    /**
     * \brief Number of occurrences of iAP2InsideTemperature parameter
     */
    U16 iAP2InsideTemperature_count;

    /**
    * \brief Vehicle's low range warning indicator
    *
    * If TRUE, Vehicle's low range warning indicator is set
    */
    U8* iAP2RangeWarning;
    /**
     * \brief Number of occurrences of iAP2RangeWarning parameter
     */
    U16 iAP2RangeWarning_count;

} iAP2VehicleStatusUpdateParameter;

/**
 * \brief Parameter structure of RequestVoiceOverActivateCursor message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for RequestVoiceOverActivateCursor message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2RequestVoiceOverActivateCursorParameter;

/**
 * \brief Parameter structure of RequestVoiceOverConfiguration message
 */
typedef struct
{
    /**
    * \brief set Voice Over Speaking Rate
    *
    * 0=off
    * 255=fastest possible speed
    */
    U8* iAP2VoiceOverSpeakingRate;
    /**
     * \brief Number of occurrences of iAP2VoiceOverSpeakingRate parameter
     */
    U16 iAP2VoiceOverSpeakingRate_count;

    /**
    * \brief Set VoiceOver Speaking Volume
    *
    * 0=muted
    * 255=loudest possible volume
    */
    U8* iAP2VoiceOverSpeakingVolume;
    /**
     * \brief Number of occurrences of iAP2VoiceOverSpeakingVolume parameter
     */
    U16 iAP2VoiceOverSpeakingVolume_count;

} iAP2RequestVoiceOverConfigurationParameter;

/**
 * \brief Parameter structure of RequestVoiceOverMoveCursor message
 */
typedef struct
{
    /**
    * \brief VoiceOver Cursur Direction
    *
    * Refers to enum iAP2VoiceOverCursorDirection
    */
    iAP2VoiceOverCursorDirection* iAP2CursorDirection;
    /**
     * \brief Number of occurrences of iAP2CursorDirection parameter
     */
    U16 iAP2CursorDirection_count;

} iAP2RequestVoiceOverMoveCursorParameter;

/**
 * \brief Parameter structure of RequestVoiceOverPauseText message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for RequestVoiceOverPauseText message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2RequestVoiceOverPauseTextParameter;

/**
 * \brief Parameter structure of RequestVoiceOverResumeText message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for RequestVoiceOverResumeText message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2RequestVoiceOverResumeTextParameter;

/**
 * \brief Parameter structure of RequestVoiceOverScrollPage message
 */
typedef struct
{
    /**
    * \brief VoiceOver Scroll Direction
    *
    * Refers to enum iAP2VoiceOverScrollDirection
    */
    iAP2VoiceOverScrollDirection* iAP2ScrollDirection;
    /**
     * \brief Number of occurrences of iAP2ScrollDirection parameter
     */
    U16 iAP2ScrollDirection_count;

} iAP2RequestVoiceOverScrollPageParameter;

/**
 * \brief Parameter structure of RequestVoiceOverSpeakText message
 */
typedef struct
{
    /**
    * \brief Text(Null terminated utf-8 string) to Speak
    *
    * If not present  , voice over will read the currently visible
    * onscreen text starting from the top. 
    * Otherwise, voice over be read the text present in this parameter
    */
    U8** iAP2VoiceOverTextToSpeak;
    /**
     * \brief Number of occurrences of iAP2VoiceOverTextToSpeak parameter
     */
    U16 iAP2VoiceOverTextToSpeak_count;

} iAP2RequestVoiceOverSpeakTextParameter;

/**
 * \brief Parameter structure of StartVoiceOverCursorUpdates message
 */
typedef struct
{
    /**
    * \brief Voice over Hint
    */
    U8* iAP2VoiceOverHint;
    /**
     * \brief Number of occurrences of iAP2VoiceOverHint parameter
     */
    U16 iAP2VoiceOverHint_count;

    /**
    * \brief Voice over label
    */
    U8* iAP2VoiceOverLabel;
    /**
     * \brief Number of occurrences of iAP2VoiceOverLabel parameter
     */
    U16 iAP2VoiceOverLabel_count;

    /**
    * \brief Voice over traits
    */
    U8* iAP2VoiceOverTraits;
    /**
     * \brief Number of occurrences of iAP2VoiceOverTraits parameter
     */
    U16 iAP2VoiceOverTraits_count;

    /**
    * \brief Voice over value
    */
    U8* iAP2VoiceOverValue;
    /**
     * \brief Number of occurrences of iAP2VoiceOverValue parameter
     */
    U16 iAP2VoiceOverValue_count;

} iAP2StartVoiceOverCursorUpdatesParameter;

/**
 * \brief Parameter structure of StartVoiceOver message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StartVoiceOver message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StartVoiceOverParameter;

/**
 * \brief Parameter structure of StartVoiceOverUpdates message
 */
typedef struct
{
    /**
    * \brief VoiceOver supported or not 
    */
    U8* iAP2VoiceOverEnabled;
    /**
     * \brief Number of occurrences of iAP2VoiceOverEnabled parameter
     */
    U16 iAP2VoiceOverEnabled_count;

    /**
    * \brief VoiceOver Speaking Rate
    */
    U8* iAP2VoiceOverSpeakingRate;
    /**
     * \brief Number of occurrences of iAP2VoiceOverSpeakingRate parameter
     */
    U16 iAP2VoiceOverSpeakingRate_count;

    /**
    * \brief VoiceOver Speaking Volume
    */
    U8* iAP2VoiceOverSpeakingVolume;
    /**
     * \brief Number of occurrences of iAP2VoiceOverSpeakingVolume parameter
     */
    U16 iAP2VoiceOverSpeakingVolume_count;

} iAP2StartVoiceOverUpdatesParameter;

/**
 * \brief Parameter structure of StopVoiceOverCursorUpdates message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopVoiceOverCursorUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopVoiceOverCursorUpdatesParameter;

/**
 * \brief Parameter structure of StopVoiceOver message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopVoiceOver message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopVoiceOverParameter;

/**
 * \brief Parameter structure of StopVoiceOverUpdates message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for StopVoiceOverUpdates message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2StopVoiceOverUpdatesParameter;

/**
 * \brief Parameter structure of VoiceOverCursorUpdate message
 */
typedef struct
{
    /**
    * \brief Voice over Hint on cursor update
    */
    U8** iAP2VoiceOverHint;
    /**
     * \brief Number of occurrences of iAP2VoiceOverHint parameter
     */
    U16 iAP2VoiceOverHint_count;

    /**
    * \brief Voice over label
    */
    U8** iAP2VoiceOverLabel;
    /**
     * \brief Number of occurrences of iAP2VoiceOverLabel parameter
     */
    U16 iAP2VoiceOverLabel_count;

    /**
    * \brief Voice over traits, An array of uint16s
    *
    * An array of uint16s
    */
    iAP2Blob* iAP2VoiceOverTraits;
    /**
     * \brief Number of occurrences of iAP2VoiceOverTraits parameter
     */
    U16 iAP2VoiceOverTraits_count;

    /**
    * \brief Voice over value
    */
    U8** iAP2VoiceOverValue;
    /**
     * \brief Number of occurrences of iAP2VoiceOverValue parameter
     */
    U16 iAP2VoiceOverValue_count;

} iAP2VoiceOverCursorUpdateParameter;

/**
 * \brief Parameter structure of VoiceOverUpdate message
 */
typedef struct
{
    /**
    * \brief TRUE or FALSE
    *
    * Voice over feature is enabled or not
    */
    U8* iAP2VoiceOverEnabled;
    /**
     * \brief Number of occurrences of iAP2VoiceOverEnabled parameter
     */
    U16 iAP2VoiceOverEnabled_count;

    /**
    * \brief VoiceOver speaking rate
    *
    * 0-muted
    * 255-fastest possible speed
    */
    U8* iAP2VoiceOverSpeakingRate;
    /**
     * \brief Number of occurrences of iAP2VoiceOverSpeakingRate parameter
     */
    U16 iAP2VoiceOverSpeakingRate_count;

    /**
    * \brief Voice Over Speaking Volume
    *
    * 0-muted
    * 255-loudest possible volume
    */
    U8* iAP2VoiceOverSpeakingVolume;
    /**
     * \brief Number of occurrences of iAP2VoiceOverSpeakingVolume parameter
     */
    U16 iAP2VoiceOverSpeakingVolume_count;

} iAP2VoiceOverUpdateParameter;

/**
 * \brief Parameter structure of AccessoryWiFiConfigurationInformation message
 */
typedef struct
{
    /**
    * \brief WiFi network Channel
    */
    U8* iAP2Channel;
    /**
     * \brief Number of occurrences of iAP2Channel parameter
     */
    U16 iAP2Channel_count;

    /**
    * \brief WiFi network Passphrase
    */
    U8** iAP2Passphrase;
    /**
     * \brief Number of occurrences of iAP2Passphrase parameter
     */
    U16 iAP2Passphrase_count;

    /**
    * \brief WiFi Security Type
    */
    iAP2WiFiSecurityType* iAP2SecurityType;
    /**
     * \brief Number of occurrences of iAP2SecurityType parameter
     */
    U16 iAP2SecurityType_count;

    /**
    * \brief WiFi network SSID
    */
    U8** iAP2WiFiSSID;
    /**
     * \brief Number of occurrences of iAP2WiFiSSID parameter
     */
    U16 iAP2WiFiSSID_count;

} iAP2AccessoryWiFiConfigurationInformationParameter;

/**
 * \brief Parameter structure of RequestAccessoryWiFiConfigurationInformation message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for RequestAccessoryWiFiConfigurationInformation message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2RequestAccessoryWiFiConfigurationInformationParameter;

/**
 * \brief Parameter structure of RequestWiFiInformation message
 */
typedef struct
{
    /**
     * \brief There is no associated parameters for RequestWiFiInformation message
     */
    //dummy variable to avoid compiler warning
    U8 dummy_variable;
} iAP2RequestWiFiInformationParameter;

/**
 * \brief Parameter structure of WiFiInformation message
 */
typedef struct
{
    /**
    * \brief WiFi Request Status
    *
    * Refers to enum iAP2WiFiRequestStatus
    */
    iAP2WiFiRequestStatus* iAP2RequestStatus;
    /**
     * \brief Number of occurrences of iAP2RequestStatus parameter
     */
    U16 iAP2RequestStatus_count;

    /**
    * \brief WiFi network SSID
    */
    U8** iAP2WiFiSSID;
    /**
     * \brief Number of occurrences of iAP2WiFiSSID parameter
     */
    U16 iAP2WiFiSSID_count;

    /**
    * \brief WiFi network Passphrase
    */
    U8** iAP2WiFiPassphrase;
    /**
     * \brief Number of occurrences of iAP2WiFiPassphrase parameter
     */
    U16 iAP2WiFiPassphrase_count;

} iAP2WiFiInformationParameter;

#ifdef __cplusplus
}
#endif

#endif
